/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.index.SchemaIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.Table;

public class DatabaseIndex
implements MappedObject {
    private final SchemaIndex schemaIndex;
    private final String name;
    private final File path;
    private final List<TableIndex> tables;
    private int mappingId;

    public DatabaseIndex(SchemaIndex schema, String name) {
        this.schemaIndex = schema;
        this.name = name;
        this.path = new File(schema.getPath(), name);
        this.path.mkdir();
        this.tables = new ArrayList<TableIndex>();
    }

    public File getPath() {
        return this.path;
    }

    public SchemaIndex getSchemaIndex() {
        return this.schemaIndex;
    }

    public void merge(Database database, boolean checkFullTextIndex) {
        Map<String, TableIndex> tableMap = this.tables.stream().collect(Collectors.toMap(TableIndex::getName, table -> table));
        for (Table table2 : database.getTables()) {
            TableIndex localTable = tableMap.get(table2.getName());
            if (localTable == null) {
                localTable = new TableIndex(this, table2.getName(), table2.getTableConfig());
                this.addTable(localTable);
            }
            if (localTable.getMappingId() == 0) {
                localTable.setMappingId(table2.getMappingId());
            }
            localTable.merge(table2);
        }
        if (checkFullTextIndex) {
            for (TableIndex tableIndex : this.tables) {
                tableIndex.checkFullTextIndex();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getFQN() {
        return this.name;
    }

    @Override
    public int getMappingId() {
        return this.mappingId;
    }

    @Override
    public void setMappingId(int mappingId) {
        this.mappingId = mappingId;
    }

    public TableIndex addTable(TableIndex table) {
        this.tables.add(table);
        return table;
    }

    public List<TableIndex> getTables() {
        return this.tables;
    }

    public TableIndex getTable(String name) {
        return this.tables.stream().filter(table -> table.getName().equals(name)).findAny().orElse(null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Database: ").append(this.name).append("\n");
        for (TableIndex table : this.tables) {
            sb.append(table.toString()).append("\n");
        }
        return sb.toString();
    }
}

