/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.SchemaStats;
import org.teamapps.universaldb.distribute.ClusterSetConfig;
import org.teamapps.universaldb.distribute.TransactionExecutionResult;
import org.teamapps.universaldb.distribute.TransactionMaster;
import org.teamapps.universaldb.distribute.TransactionReader;
import org.teamapps.universaldb.distribute.TransactionWriter;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.SchemaIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileStore;
import org.teamapps.universaldb.index.file.LocalFileStore;
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.universaldb.schema.Table;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionIdHandler;
import org.teamapps.universaldb.transaction.TransactionRequest;
import org.teamapps.universaldb.transaction.TransactionStore;

public class UniversalDB
implements DataBaseMapper,
TransactionIdHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ThreadLocal<Integer> THREAD_LOCAL_USER_ID = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Transaction> THREAD_LOCAL_TRANSACTION = new ThreadLocal();
    private final File storagePath;
    private final Map<Integer, DatabaseIndex> databaseById = new HashMap<Integer, DatabaseIndex>();
    private final Map<Integer, TableIndex> tableById = new HashMap<Integer, TableIndex>();
    private final Map<Integer, ColumnIndex> columnById = new HashMap<Integer, ColumnIndex>();
    private final SchemaIndex schemaIndex;
    private TransactionStore transactionStore;
    private SchemaStats schemaStats;
    private TransactionWriter transactionWriter;
    private TransactionReader transactionReader;
    private TransactionMaster transactionMaster;
    private final Map<TableIndex, Class> entityClassByTableIndex = new HashMap<TableIndex, Class>();
    private final Map<TableIndex, Class> queryClassByTableIndex = new HashMap<TableIndex, Class>();
    private final Map<String, TableIndex> tableIndexByPath = new HashMap<String, TableIndex>();

    public static int getUserId() {
        return THREAD_LOCAL_USER_ID.get();
    }

    public static void setUserId(int userId) {
        THREAD_LOCAL_USER_ID.set(userId);
    }

    public static void startThreadLocalTransaction() {
        THREAD_LOCAL_TRANSACTION.set(Transaction.create());
    }

    public static Transaction getThreadLocalTransaction() {
        return THREAD_LOCAL_TRANSACTION.get();
    }

    public static void executeThreadLocalTransaction() {
        Transaction transaction = THREAD_LOCAL_TRANSACTION.get();
        transaction.execute();
        THREAD_LOCAL_TRANSACTION.set(null);
    }

    public static UniversalDB createStandalone(File storagePath, SchemaInfoProvider schemaInfoProvider) throws Exception {
        return UniversalDB.createStandalone(storagePath, schemaInfoProvider, true);
    }

    public static UniversalDB createStandalone(File storagePath, SchemaInfoProvider schemaInfoProvider, boolean writeTransactionLog) throws Exception {
        LocalFileStore fileStore = new LocalFileStore(new File(storagePath, "file-store"));
        return new UniversalDB(storagePath, schemaInfoProvider, (FileStore)fileStore, writeTransactionLog);
    }

    public static UniversalDB createStandalone(File storagePath, SchemaInfoProvider schemaInfoProvider, FileStore fileStore, boolean writeTransactionLog) throws Exception {
        return new UniversalDB(storagePath, schemaInfoProvider, fileStore, writeTransactionLog);
    }

    public static UniversalDB createClusterNode(File storagePath, SchemaInfoProvider schemaInfoProvider, ClusterSetConfig clusterConfig) throws Exception {
        LocalFileStore fileStore = new LocalFileStore(new File(storagePath, "file-store"));
        return new UniversalDB(storagePath, schemaInfoProvider, (FileStore)fileStore, clusterConfig);
    }

    private UniversalDB(File storagePath, SchemaInfoProvider schemaInfo, FileStore fileStore, boolean writeTransactionLog) throws Exception {
        this.storagePath = storagePath;
        this.transactionStore = new TransactionStore(storagePath, writeTransactionLog);
        Transaction.setDataBase(this);
        Schema schema = schemaInfo.getSchema();
        String pojoPath = schema.getPojoNamespace();
        this.schemaIndex = new SchemaIndex(schema, storagePath);
        this.schemaIndex.setFileStore(fileStore);
        this.mapSchema(schema);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            String path = pojoPath + "." + database.getName().toLowerCase();
            for (TableIndex tableIndex : database.getTables()) {
                try {
                    String tableName = tableIndex.getName();
                    String className = path + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
                    Class<?> schemaClass = Class.forName(className);
                    Method method = schemaClass.getDeclaredMethod("setTableIndex", TableIndex.class);
                    method.setAccessible(true);
                    method.invoke(null, tableIndex);
                    this.entityClassByTableIndex.put(tableIndex, schemaClass);
                    this.tableIndexByPath.put(tableIndex.getFQN(), tableIndex);
                    String queryClassName = path + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1) + "Query";
                    Class<?> queryClass = Class.forName(queryClassName);
                    this.queryClassByTableIndex.put(tableIndex, queryClass);
                    for (Table view : tableIndex.getTable().getViews()) {
                        String viewName = view.getName();
                        className = path + ".Udb" + viewName.substring(0, 1).toUpperCase() + viewName.substring(1);
                        schemaClass = Class.forName(className);
                        method = schemaClass.getDeclaredMethod("setTableIndex", TableIndex.class);
                        method.setAccessible(true);
                        method.invoke(null, tableIndex);
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.info("Could not load entity class for tableIndex:" + tableIndex.getFQN());
                }
            }
        }
    }

    public void addAuxiliaryModel(SchemaInfoProvider schemaInfo, ClassLoader classLoader) throws IOException {
        Schema schema = schemaInfo.getSchema();
        Schema localSchema = this.transactionStore.getSchema();
        if (!localSchema.isCompatibleWith(schema)) {
            throw new RuntimeException("Cannot load incompatible schema. Current schema is:\n" + schema + "\nNew schema is:\n" + localSchema);
        }
        localSchema.merge(schema);
        localSchema.mapSchema();
        this.transactionStore.saveSchema(localSchema);
        this.schemaIndex.merge(localSchema, false);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            this.databaseById.put(database.getMappingId(), database);
            for (TableIndex table : database.getTables()) {
                this.tableById.put(table.getMappingId(), table);
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    this.columnById.put(columnIndex.getMappingId(), columnIndex);
                }
            }
        }
    }

    public void installAuxiliaryModelClassed(SchemaInfoProvider schemaInfo, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Schema schema = schemaInfo.getSchema();
        String pojoPath = schema.getPojoNamespace();
        for (Database database : schema.getDatabases()) {
            String path = pojoPath + "." + database.getName().toLowerCase();
            for (Table table : database.getTables()) {
                TableIndex tableIndex = this.schemaIndex.getTable(table);
                String tableName = table.getName();
                String className = path + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
                Class<?> schemaClass = Class.forName(className, true, classLoader);
                Method method = schemaClass.getDeclaredMethod("setTableIndex", TableIndex.class);
                method.setAccessible(true);
                method.invoke(null, tableIndex);
                this.entityClassByTableIndex.put(tableIndex, schemaClass);
                this.tableIndexByPath.put(tableIndex.getFQN(), tableIndex);
                String queryClassName = path + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1) + "Query";
                Class<?> queryClass = Class.forName(queryClassName, true, classLoader);
                this.queryClassByTableIndex.put(tableIndex, queryClass);
            }
        }
    }

    public Class getEntityClass(TableIndex tableIndex) {
        return this.entityClassByTableIndex.get(tableIndex);
    }

    public Class getQueryClass(TableIndex tableIndex) {
        return this.queryClassByTableIndex.get(tableIndex);
    }

    public TableIndex getTableIndexByPath(String path) {
        return this.tableIndexByPath.get(path);
    }

    public TableIndex addTable(Table table, String database) {
        DatabaseIndex db = this.schemaIndex.getDatabase(database);
        TableIndex tableIndex = new TableIndex(db, table, table.getTableConfig());
        tableIndex.setMappingId(table.getMappingId());
        tableIndex.merge(table);
        return tableIndex;
    }

    private void mapSchema(Schema schema) throws IOException {
        Schema localSchema = this.transactionStore.getSchema();
        if (localSchema != null) {
            if (!localSchema.isCompatibleWith(schema)) {
                throw new RuntimeException("Cannot load incompatible schema. Current schema is:\n" + schema + "\nNew schema is:\n" + localSchema);
            }
            localSchema.merge(schema);
        } else {
            localSchema = schema;
        }
        localSchema.mapSchema();
        this.transactionStore.saveSchema(localSchema);
        this.schemaIndex.merge(localSchema, true);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            this.databaseById.put(database.getMappingId(), database);
            for (TableIndex table : database.getTables()) {
                this.tableById.put(table.getMappingId(), table);
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    this.columnById.put(columnIndex.getMappingId(), columnIndex);
                }
            }
        }
    }

    private UniversalDB(File storagePath, SchemaInfoProvider schemaInfo, FileStore fileStore, ClusterSetConfig clusterConfig) throws Exception {
        this.storagePath = storagePath;
        this.schemaStats = new SchemaStats(storagePath);
        Transaction.setDataBase(this);
        Schema schema = schemaInfo.getSchema();
        String pojoPath = schema.getPojoNamespace();
        this.schemaIndex = new SchemaIndex(Schema.parse(schema.getPojoNamespace()), storagePath);
        this.schemaIndex.setFileStore(fileStore);
        this.mapSchemaForCluster(schema);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            String path = pojoPath + "." + database.getName().toLowerCase();
            for (TableIndex table : database.getTables()) {
                String tableName = table.getName();
                String className = path + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
                Class<?> schemaClass = Class.forName(className);
                Method method = schemaClass.getDeclaredMethod("setTableIndex", TableIndex.class);
                method.setAccessible(true);
                method.invoke(null, table);
            }
        }
        this.transactionWriter = new TransactionWriter(clusterConfig, this.schemaStats);
        this.transactionReader = new TransactionReader(clusterConfig, this.schemaStats, this, this.transactionWriter.getTransactionMap(), this);
        this.transactionMaster = new TransactionMaster(clusterConfig, this.schemaStats, this, this);
    }

    private void mapSchemaForCluster(Schema schema) throws IOException {
        Schema localSchema = this.schemaStats.getSchema();
        if (localSchema != null) {
            if (!localSchema.isCompatibleWith(schema)) {
                throw new RuntimeException("Cannot load incompatible schema. Current schema is:\n" + schema + "\nNew schema is:\n" + localSchema);
            }
            localSchema.merge(schema);
            this.schemaStats.saveSchema(localSchema);
        } else {
            localSchema = schema;
            this.schemaStats.saveSchema(localSchema);
        }
        localSchema.mapSchema();
        this.schemaIndex.merge(localSchema, true);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            this.databaseById.put(database.getMappingId(), database);
            for (TableIndex table : database.getTables()) {
                this.tableById.put(table.getMappingId(), table);
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    this.columnById.put(columnIndex.getMappingId(), columnIndex);
                }
            }
        }
    }

    public void executeTransaction(ClusterTransaction transaction, boolean asynchronous) throws IOException {
        if (this.transactionWriter != null) {
            this.executeClusterTransaction(transaction, asynchronous);
        } else {
            this.executeStandaloneTransaction(transaction);
        }
    }

    private synchronized void executeStandaloneTransaction(ClusterTransaction transaction) throws IOException {
        TransactionRequest request = transaction.createRequest();
        this.transactionStore.executeTransaction(request);
    }

    private void executeClusterTransaction(ClusterTransaction transaction, boolean asynchronous) throws IOException {
        TransactionExecutionResult transactionExecutionResult = this.transactionWriter.writeTransaction(transaction);
        if (!asynchronous) {
            transactionExecutionResult.waitForExecution();
        }
    }

    public void createDatabaseDump(File dumpFolder) throws IOException {
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            File dbFolder = new File(dumpFolder, database.getName());
            dbFolder.mkdir();
            for (TableIndex table : database.getTables()) {
                File tableFolder = new File(dbFolder, table.getName());
                tableFolder.mkdir();
                BitSet records = table.getRecords();
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    File dumpFile = new File(tableFolder, columnIndex.getName() + ".dbd");
                    columnIndex.dumpIndex(dumpFile, records);
                }
            }
        }
    }

    @Override
    public DatabaseIndex getDatabaseById(int mappingId) {
        return this.databaseById.get(mappingId);
    }

    @Override
    public TableIndex getCollectionIndexById(int mappingId) {
        return this.tableById.get(mappingId);
    }

    @Override
    public ColumnIndex getColumnById(int mappingId) {
        return this.columnById.get(mappingId);
    }

    @Override
    public long getAndCommitNextTransactionId() {
        if (this.schemaStats != null) {
            return this.schemaStats.getAndCommitNextTransactionId();
        }
        return this.transactionStore.getAndCommitNextTransactionId();
    }

    @Override
    public long getLastCommittedTransactionId() {
        if (this.schemaStats != null) {
            return this.schemaStats.getLastCommittedTransactionId();
        }
        return this.transactionStore.getLastCommittedTransactionId();
    }

    @Override
    public void commitTransactionId(long id) {
        if (this.schemaStats != null) {
            this.schemaStats.commitTransactionId(id);
        }
    }

    public SchemaStats getClusterSchemaStats() {
        return this.schemaStats;
    }

    public SchemaIndex getSchemaIndex() {
        return this.schemaIndex;
    }
}

