/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster.message;

import java.nio.ByteBuffer;
import org.teamapps.universaldb.cluster.ClusterNodeRole;
import org.teamapps.universaldb.cluster.ClusterNodeState;
import org.teamapps.universaldb.cluster.message.ClusterMessage;
import org.teamapps.universaldb.cluster.network.MessageType;

public class ClusterNodeStateInfo
implements ClusterMessage {
    private final int nodeId;
    private final int headNodeId;
    private final ClusterNodeRole operatingRole;
    private final ClusterNodeRole preferredRole;
    private final ClusterNodeState nodeState;
    private final int connectedNodesCount;
    private final int clusterQuorum;
    private final int electoralClusterNodes;
    private final int syncingWithNodeId;
    private final long syncingTransactionStarted;
    private final long lastTransactionId;
    private final long currentTransactionId;
    private final long transactionCount;
    private final byte[] data;

    public ClusterNodeStateInfo(int nodeId, int headNodeId, ClusterNodeRole operatingRole, ClusterNodeRole preferredRole, ClusterNodeState nodeState, int connectedNodesCount, int clusterQuorum, int electoralClusterNodes, int syncingWithNodeId, long syncingTransactionStarted, long lastTransactionId, long currentTransactionId, long transactionCount) {
        this.nodeId = nodeId;
        this.headNodeId = headNodeId;
        this.operatingRole = operatingRole;
        this.preferredRole = preferredRole;
        this.nodeState = nodeState;
        this.connectedNodesCount = connectedNodesCount;
        this.clusterQuorum = clusterQuorum;
        this.electoralClusterNodes = electoralClusterNodes;
        this.syncingWithNodeId = syncingWithNodeId;
        this.syncingTransactionStarted = syncingTransactionStarted;
        this.lastTransactionId = lastTransactionId;
        this.currentTransactionId = currentTransactionId;
        this.transactionCount = transactionCount;
        this.data = new byte[59];
        ByteBuffer buffer = ByteBuffer.wrap(this.data);
        buffer.putInt(nodeId);
        buffer.putInt(headNodeId);
        buffer.put((byte)operatingRole.getId());
        buffer.put((byte)preferredRole.getId());
        buffer.put((byte)nodeState.getId());
        buffer.putInt(connectedNodesCount);
        buffer.putInt(clusterQuorum);
        buffer.putInt(electoralClusterNodes);
        buffer.putInt(syncingWithNodeId);
        buffer.putLong(syncingTransactionStarted);
        buffer.putLong(lastTransactionId);
        buffer.putLong(currentTransactionId);
        buffer.putLong(transactionCount);
    }

    public ClusterNodeStateInfo(byte[] data) {
        this.data = data;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.nodeId = buffer.getInt();
        this.headNodeId = buffer.getInt();
        this.operatingRole = ClusterNodeRole.getById(buffer.get());
        this.preferredRole = ClusterNodeRole.getById(buffer.get());
        this.nodeState = ClusterNodeState.getById(buffer.get());
        this.connectedNodesCount = buffer.getInt();
        this.clusterQuorum = buffer.getInt();
        this.electoralClusterNodes = buffer.getInt();
        this.syncingWithNodeId = buffer.getInt();
        this.syncingTransactionStarted = buffer.getLong();
        this.lastTransactionId = buffer.getLong();
        this.currentTransactionId = buffer.getLong();
        this.transactionCount = buffer.getLong();
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int getHeadNodeId() {
        return this.headNodeId;
    }

    public ClusterNodeRole getOperatingRole() {
        return this.operatingRole;
    }

    public ClusterNodeRole getPreferredRole() {
        return this.preferredRole;
    }

    public ClusterNodeState getNodeState() {
        return this.nodeState;
    }

    public int getConnectedNodesCount() {
        return this.connectedNodesCount;
    }

    public int getClusterQuorum() {
        return this.clusterQuorum;
    }

    public int getElectoralClusterNodes() {
        return this.electoralClusterNodes;
    }

    public int getSyncingWithNodeId() {
        return this.syncingWithNodeId;
    }

    public long getSyncingTransactionStarted() {
        return this.syncingTransactionStarted;
    }

    public long getLastTransactionId() {
        return this.lastTransactionId;
    }

    public long getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    @Override
    public MessageType getType() {
        return MessageType.CLUSTER_NODE_STATUS_INFO;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

