/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster.message;

import java.nio.ByteBuffer;
import org.teamapps.universaldb.cluster.message.ClusterMessage;
import org.teamapps.universaldb.cluster.network.MessageType;

public class SynchronizeTransactionsStatus
implements ClusterMessage {
    private final long lastTransactionId;
    private final long currentTransactionId;
    private final long transactionCount;
    private final byte[] data;

    public SynchronizeTransactionsStatus(long lastTransactionId, long currentTransactionId, long transactionCount) {
        this.lastTransactionId = lastTransactionId;
        this.currentTransactionId = currentTransactionId;
        this.transactionCount = transactionCount;
        this.data = new byte[40];
        ByteBuffer buffer = ByteBuffer.wrap(this.data);
        buffer.putLong(lastTransactionId);
        buffer.putLong(currentTransactionId);
        buffer.putLong(transactionCount);
    }

    public SynchronizeTransactionsStatus(byte[] data) {
        this.data = data;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.lastTransactionId = buffer.getLong();
        this.currentTransactionId = buffer.getLong();
        this.transactionCount = buffer.getLong();
    }

    public long getLastTransactionId() {
        return this.lastTransactionId;
    }

    public long getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    @Override
    public MessageType getType() {
        return MessageType.SYNCHRONIZE_TRANSACTIONS_STATUS;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

