/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.binary;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.binary.BinaryFilter;
import org.teamapps.universaldb.index.binary.ByteArrayIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.transaction.DataType;
import org.teamapps.universaldb.util.DataStreamUtil;

public class BinaryIndex
extends AbstractIndex<byte[], BinaryFilter> {
    private final LongIndex positionIndex;
    private final ByteArrayIndex byteArrayIndex;
    private final boolean compressContent;

    public BinaryIndex(String name, TableIndex table, boolean compressContent, ColumnType columnType) {
        super(name, table, columnType, FullTextIndexingOptions.NOT_INDEXED);
        this.compressContent = compressContent;
        this.positionIndex = new LongIndex(name, table, columnType);
        this.byteArrayIndex = new ByteArrayIndex(this.getPath(), name, this.compressContent);
    }

    @Override
    public IndexType getType() {
        return IndexType.BINARY;
    }

    @Override
    public byte[] getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, byte[] value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, null);
    }

    public int getLength(int id) {
        long index = this.positionIndex.getValue(id);
        if (index > 0L) {
            return this.byteArrayIndex.getByteArrayLength(index);
        }
        return 0;
    }

    public Supplier<InputStream> getInputStreamSupplier(int id) {
        return () -> {
            byte[] value = this.getValue(id);
            if (value == null) {
                return null;
            }
            return new ByteArrayInputStream(value);
        };
    }

    public byte[] getValue(int id) {
        long index = this.positionIndex.getValue(id);
        if (index == 0L) {
            return null;
        }
        return this.byteArrayIndex.getByteArray(index);
    }

    public void setValue(int id, byte[] value) {
        long index = this.positionIndex.getValue(id);
        if (index != 0L) {
            this.byteArrayIndex.removeByteArray(index);
        }
        if (value != null && value.length > 0) {
            index = this.byteArrayIndex.setByteArray(value);
            this.positionIndex.setValue(id, index);
        } else {
            this.positionIndex.setValue(id, 0L);
        }
    }

    @Override
    public void writeTransactionValue(byte[] value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.STRING.getId());
        dataOutputStream.writeInt(value.length);
        dataOutputStream.write(value);
    }

    @Override
    public byte[] readTransactionValue(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        byte[] bytes = new byte[length];
        dataInputStream.read(bytes);
        return bytes;
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            byte[] value = this.getValue(id);
            dataOutputStream.writeInt(id);
            DataStreamUtil.writeByteArrayWithLengthHeader(dataOutputStream, value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            byte[] value = DataStreamUtil.readByteArrayWithLengthHeader(dataInputStream);
            this.setValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public BitSet filter(BitSet records, BinaryFilter binaryFilter) {
        return null;
    }

    @Override
    public void close() {
        this.positionIndex.close();
        this.byteArrayIndex.close();
    }

    @Override
    public void drop() {
        this.positionIndex.drop();
        this.byteArrayIndex.drop();
    }
}

