/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.teamapps.universaldb.index.reference.blockindex.MappedBuffer;
import org.teamapps.universaldb.util.MappedStoreUtil;

public class ByteArrayIndex {
    private final File path;
    private final String name;
    private final boolean compressContent;
    private MappedBuffer[] buffers;
    private MappedBuffer currentBuffer;

    public ByteArrayIndex(File path, String name, boolean compressContent) {
        this.path = path;
        this.name = name;
        this.compressContent = compressContent;
        this.init();
    }

    private void init() {
        int index = 0;
        do {
            this.addBuffer(index);
        } while (this.getStoreFile(++index).exists());
    }

    private void addBuffer() {
        this.addBuffer(this.buffers.length);
    }

    private void addBuffer(int index) {
        MappedBuffer buffer;
        this.currentBuffer = buffer = new MappedBuffer(this.getStoreFile(index), index);
        if (index == 0) {
            this.buffers = new MappedBuffer[1];
            this.buffers[0] = buffer;
        } else {
            MappedBuffer[] newBuffers = new MappedBuffer[index + 1];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = buffer;
            this.buffers = newBuffers;
        }
    }

    private File getStoreFile(int index) {
        return new File(this.path, this.name + "-" + index + ".bix");
    }

    private MappedBuffer getBufferForIndex(long index) {
        return this.buffers[MappedBuffer.getBufferIndex(index)];
    }

    public int getByteArrayLength(long index) {
        MappedBuffer buffer = this.getBufferForIndex(index);
        int position = MappedBuffer.getBlockPosition(index);
        return buffer.readInt(position);
    }

    public byte[] getByteArray(long index) {
        int position;
        MappedBuffer buffer = this.getBufferForIndex(index);
        int len = buffer.readInt(position = MappedBuffer.getBlockPosition(index));
        if (len < 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        buffer.readBytes(position + 4, bytes);
        if (this.compressContent) {
            return ByteArrayIndex.decompress(bytes);
        }
        return bytes;
    }

    public long setByteArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return 0L;
        }
        if (this.compressContent) {
            bytes = ByteArrayIndex.compress(bytes);
        }
        if (this.currentBuffer.getRemainingSize() < bytes.length + 4) {
            this.addBuffer();
        }
        int position = this.currentBuffer.getFreeSpacePosition();
        long index = this.currentBuffer.createIndex(position);
        this.currentBuffer.writeInt(bytes.length, position);
        this.currentBuffer.writeValue(bytes, position + 4);
        this.currentBuffer.setFreeSpacePosition(position + 4 + bytes.length);
        return index;
    }

    public void removeByteArray(long index) {
        MappedBuffer buffer = this.getBufferForIndex(index);
        int position = MappedBuffer.getBlockPosition(index);
        int len = buffer.readInt(position);
        len = Math.abs(len) * -1;
        buffer.writeInt(len, position);
    }

    public static byte[] compress(byte[] data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream deflate = new DeflaterOutputStream(bos);
            deflate.write(data);
            deflate.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decompress(byte[] data) {
        try {
            InflaterInputStream inflate = new InflaterInputStream(new ByteArrayInputStream(data));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inflate, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        for (MappedBuffer buffer : this.buffers) {
            buffer.flush();
        }
    }

    public void drop() {
        this.close();
        int bufferIndex = 0;
        while (this.getStoreFile(bufferIndex).exists()) {
            try {
                File file = this.getStoreFile(bufferIndex);
                MappedBuffer buffer = this.buffers[bufferIndex];
                MappedStoreUtil.deleteBufferAndData(file, buffer.getAtomicBuffer());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++bufferIndex;
        }
    }
}

