/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teamapps.universaldb.index.file.FileDataField;
import org.teamapps.universaldb.index.file.FileFilterType;
import org.teamapps.universaldb.index.file.FileFullTextFilterType;
import org.teamapps.universaldb.index.text.TextFieldFilter;
import org.teamapps.universaldb.index.text.TextFilterType;

public class FileFilter {
    private FileFilterType filterType;
    private FileFullTextFilterType fullTextFilterType;
    private List<FileDataField> fields;
    private String value;
    private long size;
    private long size2;

    public static FileFilter empty() {
        return FileFilter.sizeEquals(0L);
    }

    public static FileFilter notEmpty() {
        return FileFilter.sizeGreater(0L);
    }

    public static FileFilter termEquals(String value, FileDataField ... fields) {
        return new FileFilter(FileFullTextFilterType.TERM_EQUALS, value, fields);
    }

    public static FileFilter termNotEquals(String value, FileDataField ... fields) {
        return new FileFilter(FileFullTextFilterType.TERM_NOT_EQUALS, value, fields);
    }

    public static FileFilter termStartsWith(String value, FileDataField ... fields) {
        return new FileFilter(FileFullTextFilterType.TERM_STARTS_WITH, value, fields);
    }

    public static FileFilter termStartNotWith(String value, FileDataField ... fields) {
        return new FileFilter(FileFullTextFilterType.TERM_STARTS_NOT_WITH, value, fields);
    }

    public static FileFilter termSimilar(String value, FileDataField ... fields) {
        return new FileFilter(FileFullTextFilterType.TERM_SIMILAR, value, fields);
    }

    public static FileFilter termNotSimilar(String value, FileDataField ... fields) {
        return new FileFilter(FileFullTextFilterType.TERM_NOT_SIMILAR, value, fields);
    }

    public static FileFilter termContains(String value, FileDataField ... fields) {
        return new FileFilter(FileFullTextFilterType.TERM_CONTAINS, value, fields);
    }

    public static FileFilter termContainsNot(String value, FileDataField ... fields) {
        return new FileFilter(FileFullTextFilterType.TERM_CONTAINS_NOT, value, fields);
    }

    public static FileFilter sizeEquals(long size) {
        return new FileFilter(size, FileFilterType.SIZE_EQUALS);
    }

    public static FileFilter sizeNotEquals(long size) {
        return new FileFilter(size, FileFilterType.SIZE_NOT_EQUALS);
    }

    public static FileFilter sizeGreater(long size) {
        return new FileFilter(size, FileFilterType.SIZE_GREATER);
    }

    public static FileFilter sizeSmaller(long size) {
        return new FileFilter(size, FileFilterType.SIZE_SMALLER);
    }

    public static FileFilter sizeBetween(long size, long size2) {
        return new FileFilter(size, FileFilterType.SIZE_SMALLER);
    }

    public FileFilter(FileFilterType filterType) {
        this.filterType = filterType;
    }

    protected FileFilter(FileFullTextFilterType fullTextFilterType, String value, FileDataField ... fields) {
        this.filterType = FileFilterType.FULL_TEXT_FILTER;
        this.fullTextFilterType = fullTextFilterType;
        this.fields = Arrays.asList(fields);
        this.value = value;
    }

    protected FileFilter(long size, FileFilterType filterType) {
        this.filterType = filterType;
        this.size = size;
    }

    protected FileFilter(long size, long size2) {
        this.filterType = FileFilterType.SIZE_BETWEEN;
        this.size = size;
        this.size2 = size2;
    }

    public List<TextFieldFilter> getTextFilters() {
        ArrayList<TextFieldFilter> textFieldFilters = new ArrayList<TextFieldFilter>();
        for (FileDataField field : this.fields) {
            String fieldName = this.getFieldName(field);
            TextFilterType textFilterType = this.getTextFilterType(this.fullTextFilterType);
            TextFieldFilter fieldFilter = new TextFieldFilter(textFilterType, fieldName, this.value);
            textFieldFilters.add(fieldFilter);
        }
        return textFieldFilters;
    }

    private TextFilterType getTextFilterType(FileFullTextFilterType fileFullTextFilterType) {
        switch (this.fullTextFilterType) {
            case TERM_EQUALS: {
                return TextFilterType.TERM_EQUALS;
            }
            case TERM_NOT_EQUALS: {
                return TextFilterType.TERM_NOT_EQUALS;
            }
            case TERM_STARTS_WITH: {
                return TextFilterType.TERM_STARTS_WITH;
            }
            case TERM_STARTS_NOT_WITH: {
                return TextFilterType.TERM_STARTS_NOT_WITH;
            }
            case TERM_SIMILAR: {
                return TextFilterType.TERM_SIMILAR;
            }
            case TERM_NOT_SIMILAR: {
                return TextFilterType.TERM_NOT_SIMILAR;
            }
            case TERM_CONTAINS: {
                return TextFilterType.TERM_CONTAINS;
            }
            case TERM_CONTAINS_NOT: {
                return TextFilterType.TERM_CONTAINS_NOT;
            }
        }
        return null;
    }

    private String getFieldName(FileDataField field) {
        switch (field) {
            case NAME: {
                return "name";
            }
            case MIME_TYPE: {
                return "mime";
            }
            case HASH: {
                return "hash";
            }
            case META_DATA: {
                return "language";
            }
            case CONTENT: {
                return "content";
            }
            case CONTENT_LANGUAGE: {
                return "language";
            }
        }
        return null;
    }

    public FileFilterType getFilterType() {
        return this.filterType;
    }

    public FileFullTextFilterType getFullTextFilterType() {
        return this.fullTextFilterType;
    }

    public List<FileDataField> getFields() {
        return this.fields;
    }

    public String getValue() {
        return this.value;
    }

    public long getSize() {
        return this.size;
    }

    public long getSize2() {
        return this.size2;
    }
}

