/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.teamapps.universaldb.index.file.FileUtil;
import org.teamapps.universaldb.index.fileng.FileValue;

public class LocalFileValue
implements FileValue {
    private final File file;
    private final String name;
    private String hash;

    public LocalFileValue(File file) {
        this(file, file.getName());
    }

    public LocalFileValue(File file, String fileName) {
        this.file = file;
        this.name = fileName;
    }

    @Override
    public String getHash() {
        if (this.hash == null) {
            this.hash = FileUtil.createFileHash(this.file);
        }
        return this.hash;
    }

    @Override
    public String getFileName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public File getAsFile() {
        return this.file;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public File getFileVersion(int version) {
        if (this.getVersion() == version) {
            return this.getAsFile();
        }
        return null;
    }
}

