/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.blockindex.iterator;

import java.util.PrimitiveIterator;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlock;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBuffer;

public class SingleBlockIterator
implements PrimitiveIterator.OfInt {
    private final int blockEntries;
    private final int offset;
    private final ReferenceBuffer buffer;
    private int pos;
    private int nextValue;

    public SingleBlockIterator(ReferenceBlock block) {
        this.blockEntries = block.getBlockEntryCount();
        this.offset = block.getBlockDataPosition();
        this.buffer = block.getBuffer();
        this.retrieveNextValue();
    }

    private void retrieveNextValue() {
        if (this.pos >= this.blockEntries) {
            this.nextValue = 0;
            return;
        }
        this.nextValue = this.buffer.readInt(this.offset + this.pos * 4);
        ++this.pos;
        if (this.nextValue < 0) {
            this.retrieveNextValue();
        }
    }

    @Override
    public int nextInt() {
        int value = this.nextValue;
        this.retrieveNextValue();
        return value;
    }

    @Override
    public boolean hasNext() {
        return this.nextValue > 0;
    }
}

