/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.universaldb.index.reference.blockindex.MappedBuffer;
import org.teamapps.universaldb.util.MappedStoreUtil;

public class CharIndex {
    private final File path;
    private final String name;
    private MappedBuffer[] buffers;
    private MappedBuffer currentBuffer;
    private Map<Integer, Deque<Long>> deletedBlocksByLength;

    public CharIndex(File path, String name) {
        this.path = path;
        this.name = name;
        this.deletedBlocksByLength = new HashMap<Integer, Deque<Long>>();
        this.init();
    }

    private void init() {
        int index = 0;
        do {
            this.addBuffer(index);
        } while (this.getStoreFile(++index).exists());
    }

    private void addBuffer() {
        this.addBuffer(this.buffers.length);
    }

    private void addBuffer(int index) {
        MappedBuffer buffer;
        this.currentBuffer = buffer = new MappedBuffer(this.getStoreFile(index), index);
        if (index == 0) {
            this.buffers = new MappedBuffer[1];
            this.buffers[0] = buffer;
        } else {
            MappedBuffer[] newBuffers = new MappedBuffer[index + 1];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = buffer;
            this.buffers = newBuffers;
        }
    }

    private File getStoreFile(int index) {
        return new File(this.path, this.name + "-" + index + ".cdx");
    }

    private MappedBuffer getBufferForIndex(long index) {
        return this.buffers[MappedBuffer.getBufferIndex(index)];
    }

    public String getText(long index) {
        int position;
        MappedBuffer buffer = this.getBufferForIndex(index);
        int len = buffer.readInt(position = MappedBuffer.getBlockPosition(index));
        if (len < 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        buffer.readBytes(position + 4, bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public int getTextByteLength(long index) {
        MappedBuffer buffer = this.getBufferForIndex(index);
        int position = MappedBuffer.getBlockPosition(index);
        return buffer.readInt(position);
    }

    public long setText(String text) {
        if (text == null || text.isEmpty()) {
            return 0L;
        }
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        while (this.currentBuffer.getRemainingSize() < bytes.length + 4) {
            this.addBuffer();
        }
        int position = this.currentBuffer.getFreeSpacePosition();
        long index = this.currentBuffer.createIndex(position);
        this.currentBuffer.writeInt(bytes.length, position);
        this.currentBuffer.writeValue(bytes, position + 4);
        this.currentBuffer.setFreeSpacePosition(position + 4 + bytes.length);
        return index;
    }

    public void removeText(long index) {
        MappedBuffer buffer = this.getBufferForIndex(index);
        int position = MappedBuffer.getBlockPosition(index);
        int len = buffer.readInt(position);
        len = Math.abs(len) * -1;
    }

    public void close() {
        for (MappedBuffer buffer : this.buffers) {
            buffer.flush();
        }
    }

    public void drop() {
        this.close();
        int bufferIndex = 0;
        while (this.getStoreFile(bufferIndex).exists()) {
            try {
                File file = this.getStoreFile(bufferIndex);
                MappedBuffer buffer = this.buffers[bufferIndex];
                MappedStoreUtil.deleteBufferAndData(file, buffer.getAtomicBuffer());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++bufferIndex;
        }
    }
}

