/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.transaction.Transaction;

public class RawEntity
extends AbstractUdbEntity<RawEntity> {
    public RawEntity(TableIndex tableIndex) {
        super(tableIndex);
    }

    public List<RawEntity> getAll() {
        ArrayList<RawEntity> list = new ArrayList<RawEntity>();
        BitSet records = this.getTableIndex().getRecords();
        int id = records.nextSetBit(0);
        while (id >= 0) {
            list.add(this.build(id));
            id = records.nextSetBit(id + 1);
        }
        return list;
    }

    public String getText(String fieldName) {
        ColumnIndex columnIndex = this.getTableIndex().getColumnIndex(fieldName);
        return this.getTextValue((TextIndex)columnIndex);
    }

    public int getInt(String fieldName) {
        ColumnIndex columnIndex = this.getTableIndex().getColumnIndex(fieldName);
        return this.getIntValue((IntegerIndex)columnIndex);
    }

    public void setText(String fieldName, String value) {
        ColumnIndex columnIndex = this.getTableIndex().getColumnIndex(fieldName);
        this.setTextValue(value, (TextIndex)columnIndex);
    }

    public void setInteger(String fieldName, int value) {
        ColumnIndex columnIndex = this.getTableIndex().getColumnIndex(fieldName);
        this.setIntValue(value, (IntegerIndex)columnIndex);
    }

    public void setReference(String fieldName, RawEntity value) {
        ColumnIndex columnIndex = this.getTableIndex().getColumnIndex(fieldName);
        this.setSingleReferenceValue(columnIndex, value, null);
    }

    public RawEntity(TableIndex tableIndex, int id, boolean createEntity) {
        super(tableIndex, id, createEntity);
    }

    @Override
    public RawEntity save(Transaction transaction, boolean strictChangeVerification) {
        return null;
    }

    @Override
    public RawEntity saveTransactional(boolean strictChangeVerification) {
        return null;
    }

    @Override
    public RawEntity save() {
        this.save(this.getTableIndex());
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
    }

    @Override
    public void delete() {
        this.delete(this.getTableIndex());
    }

    @Override
    public RawEntity build() {
        return new RawEntity(this.getTableIndex(), 0, true);
    }

    @Override
    public RawEntity build(int id) {
        return new RawEntity(this.getTableIndex(), id, false);
    }
}

