/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.universaldb.cluster.ClusterHandler;
import org.teamapps.universaldb.cluster.ClusterNodeConfig;
import org.teamapps.universaldb.cluster.ClusterNodeRole;
import org.teamapps.universaldb.cluster.ClusterOperationMode;
import org.teamapps.universaldb.cluster.message.ClusterMessage;
import org.teamapps.universaldb.cluster.message.ClusterNodeStatusMessage;
import org.teamapps.universaldb.cluster.message.ConnectToHeadRequest;
import org.teamapps.universaldb.cluster.message.ConnectToHeadSuccessResponse;
import org.teamapps.universaldb.cluster.message.ConnectToHeadWaitResponse;
import org.teamapps.universaldb.cluster.message.HeadElectionProposal;
import org.teamapps.universaldb.cluster.message.InitMessage;
import org.teamapps.universaldb.cluster.message.InitMessageResponse;
import org.teamapps.universaldb.cluster.message.ResolvedTransactionRequest;
import org.teamapps.universaldb.cluster.message.SchemaUpdateMessage;
import org.teamapps.universaldb.cluster.message.SynchronizeTransactionResponse;
import org.teamapps.universaldb.cluster.message.SynchronizeTransactionsFinished;
import org.teamapps.universaldb.cluster.message.SynchronizeTransactionsRequest;
import org.teamapps.universaldb.cluster.message.SynchronizeTransactionsStatus;
import org.teamapps.universaldb.cluster.message.UnresolvedTransactionRequest;
import org.teamapps.universaldb.cluster.network.ConnectionHandler;
import org.teamapps.universaldb.cluster.network.MessageType;
import org.teamapps.universaldb.cluster.network.NetworkWriter;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.transaction.TransactionHandler;
import org.teamapps.universaldb.transaction.TransactionRequest;

public class ClusterNode
implements ConnectionHandler {
    private final ClusterNodeConfig nodeConfig;
    private final TransactionHandler transactionHandler;
    private final ClusterHandler clusterHandler;
    private final int nodeId;
    private NetworkWriter networkWriter;
    private volatile boolean connecting;
    private volatile boolean connected;
    private boolean initialized;
    private long lastTransactionId;
    private long currentTransactionId;
    private long transactionCount;
    private ClusterOperationMode clusterOperationMode;
    private ClusterNodeRole clusterNodeRole;
    private ClusterNodeRole preferredClusterNodeRole;
    private Schema schema;
    private int headIdProposal;
    private volatile boolean transactionSyncMode;
    private List<ResolvedTransactionRequest> resolvedTransactionRequests;
    private int maxTransactionRequestQueueSize = 1000;

    public ClusterNode(ClusterNodeConfig nodeConfig, TransactionHandler transactionHandler, ClusterHandler clusterHandler) {
        this.nodeConfig = nodeConfig;
        this.nodeId = nodeConfig.getNodeId();
        this.transactionHandler = transactionHandler;
        this.clusterHandler = clusterHandler;
        this.preferredClusterNodeRole = nodeConfig.getPreferredNodeType();
        this.resolvedTransactionRequests = new ArrayList<ResolvedTransactionRequest>();
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public ClusterNodeConfig getConfig() {
        return this.nodeConfig;
    }

    public void setNetworkWriter(NetworkWriter networkWriter) {
        this.networkWriter = networkWriter;
        this.connecting = false;
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public void setConnecting(boolean connecting) {
        this.connecting = connecting;
    }

    public void handleResolvedTransactionMessage(ResolvedTransactionRequest transactionRequest) {
        if (this.transactionSyncMode) {
            this.resolvedTransactionRequests.add(transactionRequest);
            if (this.resolvedTransactionRequests.size() == this.maxTransactionRequestQueueSize) {
                // empty if block
            }
        } else {
            this.sendMessage(transactionRequest);
        }
    }

    public void sendSchemaUpdate(Schema schema) throws IOException {
        SchemaUpdateMessage schemaUpdateMessage = new SchemaUpdateMessage(schema);
        this.networkWriter.sendMessage(schemaUpdateMessage);
    }

    public void sendMessage(ClusterMessage message) {
        this.networkWriter.sendMessage(message);
    }

    @Override
    public void handleConnected(NetworkWriter networkWriter) {
        this.setNetworkWriter(networkWriter);
    }

    @Override
    public void handleConnectionError() {
        this.connected = false;
        this.connecting = false;
        this.clusterHandler.handleLostConnection(this);
    }

    @Override
    public void handleMessage(MessageType messageType, byte[] data, NetworkWriter networkWriter) {
        if (this.networkWriter == null) {
            this.setNetworkWriter(networkWriter);
        }
        switch (messageType) {
            case INITIAL_MESSAGE: {
                this.handleInitialMessage(data);
                break;
            }
            case INITIAL_MESSAGE_RESPONSE: {
                this.handleInitialMessageResponse(data);
                break;
            }
            case SCHEMA_UPDATE: {
                this.handleSchemaUpdateMessage(data);
                break;
            }
            case SYNCHRONIZE_TRANSACTIONS_REQUEST: {
                this.handleSynchronizeTransactionRequest(new SynchronizeTransactionsRequest(data));
                break;
            }
            case SYNCHRONIZE_TRANSACTIONS_RESPONSE: {
                this.handleSynchronizeTransactionResponse(new SynchronizeTransactionResponse(data));
                break;
            }
            case SYNCHRONIZE_TRANSACTIONS_FINISHED: {
                this.handleSynchronizeTransactionsFinished(new SynchronizeTransactionsFinished(data));
                break;
            }
            case SYNCHRONIZE_TRANSACTIONS_STATUS: {
                this.handleSynchronizeTransactionsStatus(new SynchronizeTransactionsStatus(data));
                break;
            }
            case HEAD_ELECTION_PROPOSAL: {
                this.handleHeadElectionProposal(new HeadElectionProposal(data));
                break;
            }
            case CONNECT_TO_HEAD_REQUEST: {
                this.handleConnectToHeadRequest(new ConnectToHeadRequest(data));
                break;
            }
            case CONNECT_TO_HEAD_WAIT_RESPONSE: {
                this.handleConnectToHeadWaitResponse(new ConnectToHeadWaitResponse(data));
                break;
            }
            case CONNECT_TO_HEAD_SUCCESS_RESPONSE: {
                this.handleConnectToHeadSuccessResponse(new ConnectToHeadSuccessResponse(data));
                break;
            }
            case CLUSTER_NODE_STATUS_UPDATE: {
                this.handleClusterNodeStatusUpdate(new ClusterNodeStatusMessage(data));
                break;
            }
            case UNRESOLVED_TRANSACTION: {
                this.handleUnresolvedTransactionRequest(data);
                break;
            }
            case RESOLVED_TRANSACTION: {
                this.handleResolvedTransactionRequest(data);
            }
        }
    }

    private void handleUnresolvedTransactionRequest(byte[] data) {
        try {
            UnresolvedTransactionRequest unresolvedTransactionRequest = new UnresolvedTransactionRequest(data, this.transactionHandler.getDatabaseMapper());
            TransactionRequest transactionRequest = unresolvedTransactionRequest.getTransactionRequest();
            this.clusterHandler.handleUnresolvedTransactionRequest(transactionRequest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleResolvedTransactionRequest(byte[] data) {
        try {
            ResolvedTransactionRequest resolvedTransactionRequest = new ResolvedTransactionRequest(data, this.transactionHandler.getDatabaseMapper());
            TransactionRequest transactionRequest = resolvedTransactionRequest.getTransactionRequest();
            this.clusterHandler.handleResolvedTransactionRequest(transactionRequest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleClusterNodeStatusUpdate(ClusterNodeStatusMessage clusterNodeStatusMessage) {
        this.lastTransactionId = clusterNodeStatusMessage.getLastTransactionId();
        this.currentTransactionId = clusterNodeStatusMessage.getCurrentTransactionId();
        this.transactionCount = clusterNodeStatusMessage.getTransactionCount();
        this.clusterOperationMode = clusterNodeStatusMessage.getClusterOperationMode();
        this.clusterNodeRole = clusterNodeStatusMessage.getCurrentType();
        this.preferredClusterNodeRole = clusterNodeStatusMessage.getPreferredType();
        this.clusterHandler.handleClusterNodeStatusUpdate(clusterNodeStatusMessage, this);
    }

    private void handleConnectToHeadSuccessResponse(ConnectToHeadSuccessResponse connectToHeadSuccessResponse) {
        this.clusterHandler.handleConnectToHeadSuccessResponse(connectToHeadSuccessResponse, this);
    }

    private void handleConnectToHeadWaitResponse(ConnectToHeadWaitResponse connectToHeadWaitResponse) {
        this.clusterHandler.handleConnectToHeadWaitResponse(connectToHeadWaitResponse, this);
    }

    private void handleConnectToHeadRequest(ConnectToHeadRequest connectToHeadRequest) {
        this.clusterHandler.handleConnectToHeadRequest(connectToHeadRequest, this);
    }

    private void handleHeadElectionProposal(HeadElectionProposal headElectionProposal) {
        this.headIdProposal = headElectionProposal.getHeadId();
        this.clusterHandler.handleHeadElectionProposal(this.headIdProposal, this);
    }

    private void handleSynchronizeTransactionsStatus(SynchronizeTransactionsStatus synchronizeTransactionsStatus) {
        this.lastTransactionId = synchronizeTransactionsStatus.getLastTransactionId();
        this.currentTransactionId = synchronizeTransactionsStatus.getCurrentTransactionId();
        this.transactionCount = synchronizeTransactionsStatus.getTransactionCount();
        this.clusterHandler.handleSynchronizeTransactionsStatus(synchronizeTransactionsStatus, this);
    }

    private void handleSynchronizeTransactionsFinished(SynchronizeTransactionsFinished synchronizeTransactionsFinished) {
        this.clusterHandler.handleSynchronizeTransactionsFinished(synchronizeTransactionsFinished, this);
    }

    private void handleSynchronizeTransactionResponse(SynchronizeTransactionResponse synchronizeTransactionResponse) {
        this.clusterHandler.handleSynchronizeTransactionResponse(synchronizeTransactionResponse, this);
    }

    private void handleSynchronizeTransactionRequest(SynchronizeTransactionsRequest message) {
        this.clusterHandler.handleSynchronizeTransactionRequest(message, this.networkWriter);
    }

    private void handleSchemaUpdateMessage(byte[] data) {
        try {
            SchemaUpdateMessage schemaUpdateMessage = new SchemaUpdateMessage(data);
            this.schema = schemaUpdateMessage.getSchema();
            this.clusterHandler.handleSchemaUpdate(this.schema);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void handleInitialMessage(byte[] data) {
        try {
            this.handleInitialMessage(new InitMessage(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void handleInitialMessage(InitMessage initMessage) {
        this.lastTransactionId = initMessage.getLastTransactionId();
        this.currentTransactionId = initMessage.getCurrentTransactionId();
        this.transactionCount = initMessage.getTransactionCount();
        this.schema = initMessage.getSchema();
        this.clusterOperationMode = initMessage.getClusterOperationMode();
        this.clusterNodeRole = initMessage.getCurrentType();
        this.preferredClusterNodeRole = initMessage.getPreferredType();
        this.initialized = true;
        this.clusterHandler.handleNodeInitialized(this);
    }

    protected void handleInitialMessageResponse(byte[] data) {
        try {
            this.handleInitialMessageResponse(new InitMessageResponse(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void handleInitialMessageResponse(InitMessageResponse initMessage) {
        this.lastTransactionId = initMessage.getLastTransactionId();
        this.currentTransactionId = initMessage.getCurrentTransactionId();
        this.transactionCount = initMessage.getTransactionCount();
        this.schema = initMessage.getSchema();
        this.clusterOperationMode = initMessage.getClusterOperationMode();
        this.clusterNodeRole = initMessage.getCurrentType();
        this.preferredClusterNodeRole = initMessage.getPreferredType();
        this.initialized = true;
        this.clusterHandler.handleNodeInitializedResponse(this);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public NetworkWriter getNetworkWriter() {
        return this.networkWriter;
    }

    public long getLastTransactionId() {
        return this.lastTransactionId;
    }

    public long getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public ClusterOperationMode getClusterOperationMode() {
        return this.clusterOperationMode;
    }

    public ClusterNodeRole getClusterNodeRole() {
        return this.clusterNodeRole;
    }

    public ClusterNodeRole getPreferredClusterNodeRole() {
        return this.preferredClusterNodeRole;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int getHeadIdProposal() {
        return this.headIdProposal;
    }

    public String toString() {
        return "id:" + this.nodeId + ", type:" + this.clusterNodeRole + ", last-tr:" + this.lastTransactionId;
    }
}

