/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class ByteBufferUtil {
    public static ByteBuffer create(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public static void putBytesWithHeader(byte[] bytes, ByteBuffer buffer) {
        if (bytes == null) {
            buffer.putInt(0);
            return;
        }
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    public static byte[] getBytesWithHeader(ByteBuffer buffer) {
        int len = buffer.getInt();
        if (len == 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return bytes;
    }

    public static void putStringWithHeader(String value, ByteBuffer buffer) {
        if (value == null) {
            buffer.putInt(0);
            return;
        }
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    public static String getStringWithHeader(ByteBuffer buffer) {
        int len = buffer.getInt();
        if (len == 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

