/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.blockindex;

import java.io.File;
import java.nio.MappedByteBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.teamapps.universaldb.util.MappedStoreUtil;

public class MappedBuffer {
    private final File file;
    private final int bufferIndex;
    private final int size;
    private final AtomicBuffer atomicBuffer;
    private int freeSpacePosition;

    public File getFile() {
        return this.file;
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    public int getSize() {
        return this.size;
    }

    public static long createIndex(int buffer, int position) {
        return (long)buffer << 32 | (long)position & 0xFFFFFFFFL;
    }

    public static int getBufferIndex(long index) {
        return (int)(index >> 32);
    }

    public static int getBlockPosition(long index) {
        return (int)index;
    }

    public MappedBuffer(File file, int bufferIndex) {
        this.file = file;
        this.bufferIndex = bufferIndex;
        this.size = this.calculateSize(bufferIndex);
        this.atomicBuffer = MappedStoreUtil.createAtomicBuffer(file, this.size);
        this.freeSpacePosition = this.atomicBuffer.getInt(0);
        if (this.freeSpacePosition < 4) {
            this.freeSpacePosition = 4;
        }
    }

    private int calculateSize(int bufferIndex) {
        bufferIndex = Math.min(12, bufferIndex);
        return (int)Math.pow(2.0, bufferIndex) * 250000;
    }

    public long createIndex(int position) {
        return MappedBuffer.createIndex(this.bufferIndex, position);
    }

    public int getRemainingSize() {
        return this.size - this.freeSpacePosition;
    }

    public void setFreeSpacePosition(int position) {
        this.atomicBuffer.putInt(0, position);
        this.freeSpacePosition = position;
    }

    public int getFreeSpacePosition() {
        return this.freeSpacePosition;
    }

    public void writeByte(int value, int position) {
        this.atomicBuffer.putByteVolatile(position, (byte)value);
    }

    public void writeShort(short value, int position) {
        this.atomicBuffer.putShortVolatile(position, value);
    }

    public void writeInt(int value, int position) {
        this.atomicBuffer.putIntVolatile(position, value);
    }

    public void writeLong(long value, int position) {
        this.atomicBuffer.putLongVolatile(position, value);
    }

    public void writeValue(int value, int position, int length) {
        switch (length) {
            case 1: {
                this.writeByte(value, position);
                break;
            }
            case 2: {
                this.writeShort((short)value, position);
                break;
            }
            case 4: {
                this.writeInt(value, position);
            }
        }
    }

    public void writeValue(byte[] bytes, int position) {
        this.atomicBuffer.putBytes(position, bytes);
    }

    public int readByte(int position) {
        return this.atomicBuffer.getByteVolatile(position);
    }

    public short readShort(int position) {
        return this.atomicBuffer.getShortVolatile(position);
    }

    public int readInt(int position) {
        return this.atomicBuffer.getIntVolatile(position);
    }

    public long readLong(int position) {
        return this.atomicBuffer.getLongVolatile(position);
    }

    public void readBytes(int position, byte[] bytes) {
        this.atomicBuffer.getBytes(position, bytes);
    }

    public int readValue(int position, int length) {
        switch (length) {
            case 1: {
                return this.readByte(position);
            }
            case 2: {
                return this.readShort(position);
            }
            case 4: {
                return this.readInt(position);
            }
        }
        return 0;
    }

    public void flush() {
        MappedByteBuffer buffer = (MappedByteBuffer)this.atomicBuffer.byteBuffer();
        buffer.force();
    }

    public AtomicBuffer getAtomicBuffer() {
        return this.atomicBuffer;
    }
}

