/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.blockindex;

import java.io.File;
import org.teamapps.universaldb.index.reference.blockindex.BlockType;
import org.teamapps.universaldb.index.reference.blockindex.MappedBuffer;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlock;

public class ReferenceBuffer
extends MappedBuffer {
    public ReferenceBuffer(File file, int bufferIndex) {
        super(file, bufferIndex);
    }

    public ReferenceBlock getBlock(long index) {
        int blockPosition = ReferenceBuffer.getBlockPosition(index);
        return new ReferenceBlock(index, this, blockPosition, this.getBlockType(blockPosition));
    }

    public void setBlockData(long index, ReferenceBlock block) {
        int blockPosition = ReferenceBuffer.getBlockPosition(index);
        block.reset(index, this, blockPosition, this.getBlockType(blockPosition));
    }

    public void addBlock(ReferenceBlock writerBlock, BlockType blockType) {
        int blockPosition = this.getFreeSpacePosition();
        this.setFreeSpacePosition(blockPosition + blockType.getBlockSize());
        long index = this.createIndex(blockPosition);
        writerBlock.reset(index, this, blockPosition, blockType);
        this.writeByte(blockType.getId(), blockPosition);
    }

    private BlockType getBlockType(int blockPosition) {
        return BlockType.getById(Math.abs(this.readByte(blockPosition)));
    }

    private int getRemainingEntries(int blockPosition) {
        BlockType blockType = BlockType.getById(this.readByte(blockPosition));
        if (!blockType.canContainEmptyEntries()) {
            return 0;
        }
        int entries = this.readValue(blockPosition + 1, blockType.getEntryCountSize());
        return blockType.getMaxEntries() - entries;
    }
}

