/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.teamapps.universaldb.index.file.FileUtil;
import org.teamapps.universaldb.index.text.SearchCollector;
import org.teamapps.universaldb.index.text.SearchIndexUtil;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextFilter;

public class TextSearchIndex {
    public static final String VALUE = "value";
    public static final String ID = "id";
    private File dir;
    private StringField idSearchField;
    private NumericDocValuesField idField;
    private Field valueField;
    private IndexWriter writer;
    private Analyzer queryAnalyzer;
    private FieldType fieldType;

    public TextSearchIndex(File path, String name) {
        try {
            this.dir = new File(path, name);
            FSDirectory directory = FSDirectory.open((Path)this.dir.toPath());
            StandardAnalyzer analyzer = new StandardAnalyzer();
            this.queryAnalyzer = new StandardAnalyzer();
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            iwc.setRAMBufferSizeMB(12.0);
            this.writer = new IndexWriter((Directory)directory, iwc);
            this.idSearchField = new StringField(ID, "", Field.Store.NO);
            this.idField = new NumericDocValuesField(ID, 0L);
            this.fieldType = SearchIndexUtil.createIndexFieldType();
            this.valueField = new Field(VALUE, (CharSequence)"", (IndexableFieldType)this.fieldType);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.writer != null && this.writer.isOpen()) {
                    try {
                        this.writer.commit();
                        this.writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addValue(int id, String value, boolean update) {
        try {
            this.idSearchField.setStringValue("" + id);
            this.idField.setLongValue((long)id);
            this.valueField.setStringValue(value);
            Document doc = new Document();
            doc.add((IndexableField)this.idSearchField);
            doc.add((IndexableField)this.idField);
            doc.add((IndexableField)this.valueField);
            if (update) {
                Term term = new Term(ID, "" + id);
                this.writer.updateDocument(term, (Iterable)doc);
            } else {
                this.writer.addDocument((Iterable)doc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addValue(int id, TranslatableText value, boolean update) {
        try {
            this.idSearchField.setStringValue("" + id);
            this.idField.setLongValue((long)id);
            Document doc = new Document();
            doc.add((IndexableField)this.idSearchField);
            doc.add((IndexableField)this.idField);
            Map<String, String> translationMap = value.getTranslationMap();
            for (String language : translationMap.keySet()) {
                String translationValue = translationMap.get(language) != null ? translationMap.get(language) : "";
                Field field = new Field("value_" + language, (CharSequence)translationValue, (IndexableFieldType)this.fieldType);
                doc.add((IndexableField)field);
            }
            if (update) {
                Term term = new Term(ID, "" + id);
                this.writer.updateDocument(term, (Iterable)doc);
            } else {
                this.writer.addDocument((Iterable)doc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeValue(int id) {
        try {
            Term term = new Term(ID, "" + id);
            this.writer.deleteDocuments(new Term[]{term});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BitSet filter(BitSet bitSet, TextFilter textFilter) {
        try {
            if (textFilter == null) {
                return bitSet;
            }
            DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer, (boolean)false, (boolean)false);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            SearchCollector collector = new SearchCollector();
            Query query = SearchIndexUtil.createQuery(textFilter.getFilterType(), VALUE, textFilter.getValue(), this.queryAnalyzer);
            searcher.search(query, (Collector)collector);
            BitSet resultIds = collector.getResultIds();
            resultIds.and(bitSet);
            return resultIds;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BitSet filter(BitSet bitSet, TranslatableTextFilter textFilter) {
        try {
            if (textFilter == null) {
                return bitSet;
            }
            DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer, (boolean)false, (boolean)false);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            SearchCollector collector = new SearchCollector();
            BooleanQuery.Builder translatableQueries = new BooleanQuery.Builder();
            Query originalLanguage = SearchIndexUtil.createQuery(textFilter.getFilterType(), VALUE, textFilter.getValue(), this.queryAnalyzer);
            translatableQueries.add(originalLanguage, BooleanClause.Occur.SHOULD);
            for (String language : textFilter.getRankedLanguages()) {
                Query query = SearchIndexUtil.createQuery(textFilter.getFilterType(), "value_" + language, textFilter.getValue(), this.queryAnalyzer);
                translatableQueries.add(query, BooleanClause.Occur.SHOULD);
            }
            searcher.search((Query)translatableQueries.build(), (Collector)collector);
            BitSet resultIds = collector.getResultIds();
            resultIds.and(bitSet);
            return resultIds;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void commit(boolean close) {
        try {
            if (this.writer != null && this.writer.isOpen()) {
                this.writer.commit();
                if (close) {
                    this.writer.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public int getMaxDoc() {
        return this.writer.getDocStats().maxDoc;
    }

    public void deleteAllDocuments() throws IOException {
        this.writer.deleteAll();
        this.writer.commit();
    }

    public void drop() {
        this.commit(true);
        FileUtil.deleteFileRecursive(this.dir);
    }
}

