/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.teamapps.universaldb.transaction.TransactionStore;

public class ByteArrayTransactionReader
implements Iterator<byte[]> {
    private final File path;
    private int startFileId;
    private int startPosition;
    private int lastFiledId;
    private int lastPosition;
    private int currentFileId;
    private int currentPosition;
    private BufferedInputStream inputStream;

    public ByteArrayTransactionReader(long startTransactionId, long lastTransactionId, File path) throws IOException {
        this.path = path;
        this.startFileId = TransactionStore.getTransactionFileId(startTransactionId);
        this.startPosition = TransactionStore.getTransactionFilePosition(startTransactionId);
        this.lastFiledId = TransactionStore.getTransactionFileId(lastTransactionId);
        this.lastPosition = TransactionStore.getTransactionFilePosition(lastTransactionId);
        this.currentFileId = this.startFileId;
        this.currentPosition = this.startPosition;
        this.nextTransactionFile(this.currentPosition);
    }

    private void nextTransactionFile(int skipBytes) throws IOException {
        boolean compressed = true;
        File transactionFile = TransactionStore.getTransactionFileByFileId(this.currentFileId, this.path, compressed);
        if (!transactionFile.exists()) {
            compressed = false;
            transactionFile = TransactionStore.getTransactionFileByFileId(this.currentFileId, this.path, compressed);
        }
        if (compressed) {
            this.inputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(transactionFile)));
            this.skipBytes(skipBytes);
        } else if (skipBytes == 0) {
            this.inputStream = new BufferedInputStream(new FileInputStream(transactionFile));
        } else {
            RandomAccessFile raf = new RandomAccessFile(transactionFile, "r");
            raf.seek(skipBytes);
            this.inputStream = new BufferedInputStream(Channels.newInputStream(raf.getChannel()));
        }
    }

    private void skipBytes(int len) throws IOException {
        if (len == 0) {
            return;
        }
        int read = 0;
        byte[] buf = new byte[8096];
        for (int skipped = 0; (read = this.inputStream.read(buf, 0, Math.min(buf.length, len))) >= 0 && len > skipped; skipped += read) {
        }
    }

    private byte[] readNextPacket() {
        try {
            byte[] bytes = this.inputStream.readNBytes(5);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            byte type = buffer.get();
            int len = buffer.getInt();
            if (len <= 0 || len > 1000000000) {
                return null;
            }
            bytes = this.inputStream.readNBytes(len);
            if (TransactionStore.newTransactionFileRequired(this.currentPosition, len + 5)) {
                ++this.currentFileId;
                if (this.currentFileId > this.lastFiledId) {
                    return bytes;
                }
                this.currentPosition = 0;
                this.nextTransactionFile(0);
            } else {
                this.currentPosition += len + 5;
            }
            return bytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentFileId < this.lastFiledId || this.currentFileId == this.lastFiledId && this.currentPosition <= this.lastPosition;
    }

    @Override
    public byte[] next() {
        return this.readNextPacket();
    }
}

