/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.IOException;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.TransactionIdHandler;
import org.teamapps.universaldb.transaction.TransactionPacket;

public class TransactionRequest {
    private final ClusterTransaction transaction;
    private TransactionPacket packet;
    private volatile boolean isExecuted;

    public TransactionRequest(ClusterTransaction transaction) {
        this.transaction = transaction;
    }

    public TransactionRequest(TransactionPacket packet, DataBaseMapper dataBaseMapper) throws IOException {
        this.packet = packet;
        this.transaction = new ClusterTransaction(packet, dataBaseMapper);
    }

    public TransactionPacket getPacket() throws IOException {
        if (this.packet == null) {
            this.packet = this.transaction.createTransactionPacket();
        }
        return this.packet;
    }

    public ClusterTransaction getTransaction() {
        return this.transaction;
    }

    public boolean isExecuted() {
        return this.transaction.getTransactionId() != 0L;
    }

    public void executeUnresolvedTransaction(TransactionIdHandler transactionIdHandler) throws IOException {
        this.packet = this.transaction.resolveAndExecuteTransaction(transactionIdHandler, this.packet);
    }

    public void executeResolvedTransaction(TransactionIdHandler transactionIdHandler) {
        this.transaction.executeResolvedTransaction(transactionIdHandler);
    }

    public synchronized void waitForExecution() {
        while (!this.isExecuted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void setExecuted() {
        this.isExecuted = true;
        this.notifyAll();
    }
}

