/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.file.FileStore;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlockChain;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlockChainImpl;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.CharIndex;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.FullTextIndexValue;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.query.AndFilter;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.OrFilter;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Table;

public class TableIndex
implements MappedObject {
    private static final Logger log = LoggerFactory.getLogger(TableIndex.class);
    private final DatabaseIndex databaseIndex;
    private final Table table;
    private final String name;
    private final String parentFQN;
    private final File path;
    private final TableConfig tableConfig;
    private boolean keepDeletedRecords;
    private BooleanIndex records;
    private BooleanIndex deletedRecords;
    private LongIndex transactionIndex;
    private List<ColumnIndex> columnIndices;
    private Map<String, ColumnIndex> columnIndexByName;
    private CharIndex collectionCharIndex;
    private CollectionTextSearchIndex collectionTextSearchIndex;
    private ReferenceBlockChain referenceBlockChain;
    private List<String> fileFieldNames;
    private List<TextIndex> textFields;
    private List<TranslatableTextIndex> translatedTextFields;
    private int mappingId;

    public TableIndex(DatabaseIndex database, Table table, TableConfig tableConfig) {
        this(database, database.getPath(), database.getFQN(), table, tableConfig);
    }

    public TableIndex(DatabaseIndex databaseIndex, File parentPath, String parentFQN, Table table, TableConfig tableConfig) {
        this.databaseIndex = databaseIndex;
        this.table = table;
        this.name = table.getName();
        this.parentFQN = parentFQN;
        this.path = new File(parentPath, this.name);
        this.path.mkdir();
        this.records = new BooleanIndex("coll-recs", this, ColumnType.BOOLEAN);
        this.tableConfig = tableConfig;
        this.columnIndices = new ArrayList<ColumnIndex>();
        this.columnIndexByName = new HashMap<String, ColumnIndex>();
        if (tableConfig.keepDeleted()) {
            this.keepDeletedRecords = true;
            this.deletedRecords = new BooleanIndex("coll-del-recs", this, ColumnType.BOOLEAN);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public ReferenceBlockChain getReferenceBlockChain() {
        if (this.referenceBlockChain == null) {
            this.referenceBlockChain = new ReferenceBlockChainImpl(this.path, "ref.graph");
        }
        return this.referenceBlockChain;
    }

    public CharIndex getCollectionCharIndex() {
        if (this.collectionCharIndex == null) {
            this.collectionCharIndex = new CharIndex(this.path, "coll-text");
        }
        return this.collectionCharIndex;
    }

    public CollectionTextSearchIndex getCollectionTextSearchIndex() {
        if (this.collectionTextSearchIndex == null) {
            this.collectionTextSearchIndex = new CollectionTextSearchIndex(this.path, "coll-text");
        }
        return this.collectionTextSearchIndex;
    }

    public void checkFullTextIndex() {
        if (this.collectionTextSearchIndex == null) {
            return;
        }
        if (!this.records.getValue(0) && this.getCount() > 0 || this.getCount() > 0 && this.collectionTextSearchIndex.getMaxDoc() == 0) {
            long time = System.currentTimeMillis();
            log.warn("RECREATING FULL TEXT INDEX FOR: " + this.getName() + " (RECORDS:" + this.getCount() + ", MAX-DOC:" + this.collectionTextSearchIndex.getMaxDoc() + ")");
            this.recreateFullTextIndex();
            log.warn("RECREATING FINISHED FOR: " + this.getName() + " (TIME:" + (System.currentTimeMillis() - time) + ")");
        }
        this.records.setValue(0, false);
    }

    public void forceFullTextIndexRecreation() {
        log.warn("FORCED RECREATING FULL TEXT INDEX FOR: " + this.getName() + " (RECORDS:" + this.getCount() + ", MAX-DOC:" + this.collectionTextSearchIndex.getMaxDoc() + ")");
        this.recreateFullTextIndex();
    }

    private void recreateFullTextIndex() {
        try {
            this.collectionTextSearchIndex.deleteAllDocuments();
            BitSet bitSet = this.records.getBitSet();
            int id = bitSet.nextSetBit(0);
            while (id >= 0) {
                Object value;
                ArrayList<FullTextIndexValue> values = new ArrayList<FullTextIndexValue>();
                for (TextIndex textField : this.getTextFields()) {
                    value = textField.getValue(id);
                    if (value == null) continue;
                    values.add(new FullTextIndexValue(textField.getName(), (String)value));
                }
                for (TranslatableTextIndex translatableTextIndex : this.getTranslatedTextFields()) {
                    value = translatableTextIndex.getValue(id);
                    if (value == null) continue;
                    values.add(new FullTextIndexValue(translatableTextIndex.getName(), (TranslatableText)value));
                }
                if (!values.isEmpty()) {
                    this.collectionTextSearchIndex.setRecordValues(id, values, false);
                }
                id = bitSet.nextSetBit(id + 1);
            }
            this.collectionTextSearchIndex.commit(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Table getTable() {
        return this.table;
    }

    public FileStore getFileStore() {
        return this.databaseIndex.getSchemaIndex().getFileStore();
    }

    public File getPath() {
        return this.path;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public BitSet getRecords() {
        return this.records.getBitSet();
    }

    public int getCount() {
        return this.records.getCount();
    }

    public BitSet getDeletedRecords() {
        if (!this.keepDeletedRecords) {
            return null;
        }
        return this.deletedRecords.getBitSet();
    }

    public boolean isDeleted(int id) {
        if (this.deletedRecords != null) {
            return this.deletedRecords.getValue(id);
        }
        return !this.records.getValue(id);
    }

    public void addIndex(ColumnType type, String name) {
        ColumnIndex column = ColumnIndex.createColumn(this, name, type);
        this.addIndex(column);
    }

    public void addIndex(ColumnIndex index) {
        this.columnIndices.add(index);
        this.columnIndexByName.put(index.getName(), index);
        this.fileFieldNames = null;
        this.textFields = null;
    }

    public Filter createFullTextFilter(String query, String ... fieldNames) {
        String[] terms;
        AndFilter andFilter = new AndFilter();
        if (query == null || query.isBlank()) {
            return andFilter;
        }
        for (String term : terms = query.split(" ")) {
            if (term.isBlank()) continue;
            boolean isNegation = term.startsWith("!");
            TextFilter textFilter = this.parseTextFilter(term);
            Filter fullTextFilter = this.createFullTextFilter(textFilter, !isNegation, fieldNames);
            andFilter.and(fullTextFilter);
        }
        return andFilter;
    }

    private TextFilter parseTextFilter(String term) {
        boolean negation = false;
        boolean similar = false;
        boolean startsWith = false;
        boolean equals = false;
        if (term.startsWith("!")) {
            negation = true;
            term = term.substring(1);
        }
        if (term.endsWith("+")) {
            similar = true;
            term = term.substring(0, term.length() - 1);
        }
        if (term.endsWith("*")) {
            startsWith = true;
            term = term.substring(0, term.length() - 1);
        }
        if (term.contains("\"")) {
            equals = true;
            term = term.replace("\"", "");
        }
        if (equals) {
            return negation ? TextFilter.termEqualsFilter(term) : TextFilter.termNotEqualsFilter(term);
        }
        if (similar) {
            return negation ? TextFilter.termNotSimilarFilter(term) : TextFilter.termSimilarFilter(term);
        }
        if (startsWith) {
            return negation ? TextFilter.termStartsNotWithFilter(term) : TextFilter.termStartsWithFilter(term);
        }
        return negation ? TextFilter.termContainsNotFilter(term) : TextFilter.termContainsFilter(term);
    }

    public Filter createFullTextFilter(TextFilter textFilter, String ... fieldNames) {
        return this.createFullTextFilter(textFilter, true, fieldNames);
    }

    public Filter createFullTextFilter(TextFilter textFilter, boolean orQuery, String ... fieldNames) {
        Filter filter;
        Filter filter2 = filter = orQuery ? new OrFilter() : new AndFilter();
        if (fieldNames == null || fieldNames.length == 0) {
            this.columnIndices.stream().filter(columnIndex -> columnIndex.getType() == IndexType.TEXT || columnIndex.getType() == IndexType.TRANSLATABLE_TEXT).forEach(columnIndex -> {
                IndexFilter indexFilter = new IndexFilter(columnIndex, textFilter);
                if (orQuery) {
                    filter.or(indexFilter);
                } else {
                    filter.and(indexFilter);
                }
            });
        } else {
            for (String fieldName : fieldNames) {
                ColumnIndex columnIndex2 = this.columnIndexByName.get(fieldName);
                if ((columnIndex2 == null || columnIndex2.getType() != IndexType.TEXT) && columnIndex2.getType() != IndexType.TRANSLATABLE_TEXT) continue;
                IndexFilter indexFilter = new IndexFilter(columnIndex2, textFilter);
                if (orQuery) {
                    filter.or(indexFilter);
                    continue;
                }
                filter.and(indexFilter);
            }
        }
        return filter;
    }

    public List<SortEntry> sortRecords(String columnName, BitSet records, boolean ascending, SingleReferenceIndex ... path) {
        ColumnIndex column = null;
        column = path != null && path.length > 0 ? path[path.length - 1].getReferencedTable().getColumnIndex(columnName) : this.getColumnIndex(columnName);
        if (column == null) {
            return null;
        }
        List<SortEntry> sortEntries = SortEntry.createSortEntries(records, path);
        return column.sortRecords(sortEntries, ascending, UserContext.create());
    }

    public int createRecord(int recordId, int correlationId, boolean update) {
        int id = 0;
        if (recordId == 0) {
            id = this.keepDeletedRecords ? Math.max(this.records.getNextId(), this.deletedRecords.getNextId()) : this.records.getNextId();
        } else {
            id = recordId;
            if (this.keepDeletedRecords && this.deletedRecords.getValue(recordId)) {
                this.deletedRecords.setValue(recordId, false);
            }
        }
        this.records.setValue(id, true);
        return id;
    }

    public void updateFullTextIndex(int id, List<FullTextIndexValue> values, boolean update) {
        if (update) {
            Set textFieldNames = values.stream().map(FullTextIndexValue::getFieldName).collect(Collectors.toSet());
            ArrayList<FullTextIndexValue> recordFullTextIndexValues = new ArrayList<FullTextIndexValue>(values);
            for (TextIndex textField : this.getTextFields()) {
                if (textFieldNames.contains(textField.getName())) continue;
                recordFullTextIndexValues.add(new FullTextIndexValue(textField.getName(), textField.getValue(id)));
            }
            for (TranslatableTextIndex translatableTextIndex : this.getTranslatedTextFields()) {
                TranslatableText translatableTextValue;
                if (textFieldNames.contains(translatableTextIndex.getName()) || (translatableTextValue = translatableTextIndex.getValue(id)) == null) continue;
                recordFullTextIndexValues.add(new FullTextIndexValue(translatableTextIndex.getName(), translatableTextValue));
            }
            this.collectionTextSearchIndex.setRecordValues(id, recordFullTextIndexValues, true);
        } else {
            this.collectionTextSearchIndex.setRecordValues(id, values, false);
        }
    }

    public boolean deleteRecord(int id) {
        this.records.setValue(id, false);
        if (this.keepDeletedRecords) {
            this.deletedRecords.setValue(id, true);
            for (ColumnIndex columnIndex : this.columnIndices) {
                if (!columnIndex.getColumnType().isReference()) continue;
                if (columnIndex.getColumnType() == ColumnType.MULTI_REFERENCE) {
                    MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)columnIndex;
                    if (multiReferenceIndex.isCascadeDeleteReferences()) {
                        this.cascadeDeleteMultiReferences(id, multiReferenceIndex);
                        continue;
                    }
                    this.deleteMultiIndexBackReferences(id, multiReferenceIndex);
                    continue;
                }
                SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)columnIndex;
                if (singleReferenceIndex.isCascadeDeleteReferences()) {
                    this.cascadeDeleteSingleReference(id, singleReferenceIndex);
                    continue;
                }
                this.deleteSingleIndexBackReference(id, singleReferenceIndex);
            }
            return true;
        }
        for (ColumnIndex columnIndex : this.columnIndices) {
            if (columnIndex.getColumnType().isReference()) {
                if (columnIndex.getColumnType() == ColumnType.MULTI_REFERENCE) {
                    MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)columnIndex;
                    if (multiReferenceIndex.isCascadeDeleteReferences()) {
                        this.cascadeDeleteMultiReferences(id, multiReferenceIndex);
                    }
                } else {
                    SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)columnIndex;
                    if (singleReferenceIndex.isCascadeDeleteReferences()) {
                        this.cascadeDeleteSingleReference(id, singleReferenceIndex);
                    }
                }
            }
            columnIndex.removeValue(id);
        }
        if (this.collectionTextSearchIndex != null) {
            this.collectionTextSearchIndex.delete(id, this.getFileFieldNames());
        }
        return false;
    }

    public void cascadeDeleteSingleReference(int id, SingleReferenceIndex singleReferenceIndex) {
        TableIndex referencedTable = singleReferenceIndex.getReferencedTable();
        int reference = singleReferenceIndex.getValue(id);
        referencedTable.deleteRecord(reference);
    }

    public void cascadeDeleteMultiReferences(int id, MultiReferenceIndex multiReferenceIndex) {
        TableIndex referencedTable = multiReferenceIndex.getReferencedTable();
        List<Integer> references = multiReferenceIndex.getReferencesAsList(id);
        for (Integer reference : references) {
            referencedTable.deleteRecord(reference);
        }
    }

    public void deleteMultiIndexBackReferences(int id, MultiReferenceIndex multiReferenceIndex) {
        block5: {
            ColumnIndex referencedColumn = multiReferenceIndex.getReferencedColumn();
            if (referencedColumn == null) break block5;
            List<Integer> references = multiReferenceIndex.getReferencesAsList(id);
            if (references.isEmpty()) {
                return;
            }
            if (referencedColumn.getColumnType() == ColumnType.MULTI_REFERENCE) {
                MultiReferenceIndex referencedMultiIndex = (MultiReferenceIndex)referencedColumn;
                List<Integer> thisRecord = Collections.singletonList(id);
                for (Integer reference : references) {
                    referencedMultiIndex.removeReferences(reference, thisRecord, false);
                }
            } else {
                SingleReferenceIndex referencedSingleIndex = (SingleReferenceIndex)referencedColumn;
                for (Integer reference : references) {
                    int backReferenceId = referencedSingleIndex.getValue(reference);
                    if (backReferenceId != id) continue;
                    referencedSingleIndex.setValue(reference, 0);
                }
            }
        }
    }

    public void deleteSingleIndexBackReference(int id, SingleReferenceIndex singleReferenceIndex) {
        ColumnIndex referencedColumn = singleReferenceIndex.getReferencedColumn();
        if (referencedColumn != null) {
            int reference = singleReferenceIndex.getValue(id);
            if (reference <= 0) {
                return;
            }
            if (referencedColumn.getColumnType() == ColumnType.MULTI_REFERENCE) {
                MultiReferenceIndex referencedMultiIndex = (MultiReferenceIndex)referencedColumn;
                referencedMultiIndex.removeReferences(reference, Collections.singletonList(id), false);
            } else {
                SingleReferenceIndex referencedSingleIndex = (SingleReferenceIndex)referencedColumn;
                int backReference = referencedSingleIndex.getValue(reference);
                if (backReference == id) {
                    referencedSingleIndex.setValue(reference, 0);
                }
            }
        }
    }

    public void setTransactionId(int id, long transactionId) {
        if (!this.tableConfig.isCheckpoints()) {
            return;
        }
        if (this.transactionIndex == null) {
            this.transactionIndex = this.getTransactionIndex();
        }
        this.transactionIndex.setValue(id, transactionId);
    }

    public long getTransactionId(int id) {
        if (id == 0 || !this.tableConfig.isCheckpoints()) {
            return 0L;
        }
        if (this.transactionIndex == null) {
            this.transactionIndex = this.getTransactionIndex();
        }
        return this.transactionIndex.getValue(id);
    }

    private LongIndex getTransactionIndex() {
        if (!this.tableConfig.isCheckpoints()) {
            return null;
        }
        return (LongIndex)this.getColumnIndex("metaLastTransactionId");
    }

    private List<String> getFileFieldNames() {
        if (this.fileFieldNames == null) {
            this.fileFieldNames = this.columnIndices.stream().filter(index -> index.getType() == IndexType.FILE).map(ColumnIndex::getName).collect(Collectors.toList());
        }
        return this.fileFieldNames;
    }

    private List<TextIndex> getTextFields() {
        if (this.textFields == null) {
            this.textFields = this.columnIndices.stream().filter(index -> index.getType() == IndexType.TEXT).map(index -> (TextIndex)index).collect(Collectors.toList());
        }
        return this.textFields;
    }

    private List<TranslatableTextIndex> getTranslatedTextFields() {
        if (this.translatedTextFields == null) {
            this.translatedTextFields = this.columnIndices.stream().filter(index -> index.getType() == IndexType.TRANSLATABLE_TEXT).map(index -> (TranslatableTextIndex)index).collect(Collectors.toList());
        }
        return this.translatedTextFields;
    }

    public BitSet getRecordBitSet() {
        return this.records.getBitSet();
    }

    public BitSet getDeletedRecordsBitSet() {
        if (!this.keepDeletedRecords) {
            return null;
        }
        return this.deletedRecords.getBitSet();
    }

    public List<ColumnIndex> getColumnIndices() {
        return this.columnIndices;
    }

    public ColumnIndex getColumnIndex(String name) {
        return this.columnIndexByName.get(name);
    }

    @Override
    public int getMappingId() {
        return this.mappingId;
    }

    @Override
    public void setMappingId(int id) {
        if (this.mappingId > 0) {
            throw new RuntimeException("Cannot set new mapping id for index:" + this.name + " as it is already mapped");
        }
        this.mappingId = id;
    }

    public void merge(Table table) {
        for (Column column : table.getColumns()) {
            ColumnIndex localColumn = this.getColumnIndex(column.getName());
            if (localColumn == null) {
                localColumn = ColumnIndex.createColumn(this, column.getName(), column.getType());
                this.addIndex(localColumn);
            }
            if (localColumn.getMappingId() != 0) continue;
            localColumn.setMappingId(column.getMappingId());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("collection: ").append(this.name).append(", id:").append(this.mappingId).append("\n");
        for (ColumnIndex column : this.columnIndices) {
            sb.append("\t").append(column.toString()).append("\n");
        }
        return sb.toString();
    }

    public void close() {
        try {
            log.info("Shutdown on collection:" + this.name);
            if (this.collectionTextSearchIndex != null) {
                this.collectionTextSearchIndex.commit(true);
            }
            this.records.setValue(0, true);
            this.records.close();
            for (ColumnIndex column : this.columnIndices) {
                column.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        this.collectionTextSearchIndex.drop();
        for (ColumnIndex column : this.columnIndices) {
            column.drop();
        }
    }

    @Override
    public String getFQN() {
        return this.parentFQN + "." + this.name;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseIndex getDatabaseIndex() {
        return this.databaseIndex;
    }
}

