/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.blockindex;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.teamapps.universaldb.index.reference.blockindex.BlockType;
import org.teamapps.universaldb.index.reference.blockindex.DeletedBlock;
import org.teamapps.universaldb.index.reference.blockindex.MappedBuffer;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlock;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlockChain;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlockProvider;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBuffer;
import org.teamapps.universaldb.index.reference.blockindex.iterator.ChainedBlockIterator;
import org.teamapps.universaldb.index.reference.blockindex.iterator.DoubleValueIterator;
import org.teamapps.universaldb.index.reference.blockindex.iterator.SingleBlockIterator;
import org.teamapps.universaldb.index.reference.blockindex.iterator.SingleValueIterator;
import org.teamapps.universaldb.util.MappedStoreUtil;

public class ReferenceBlockChainImpl
implements ReferenceBlockChain,
ReferenceBlockProvider {
    private static final int MAX_DELETED_BLOCKS = 100000;
    private ReferenceBuffer[] buffers;
    private ReferenceBuffer currentBuffer;
    private File path;
    private String name = "rel";
    private Map<Integer, Deque<DeletedBlock>> deletedBlocksByType;
    private ReferenceBlock writerBlock;

    public ReferenceBlockChainImpl(File path, String name) {
        this.path = path;
        if (name != null) {
            this.name = name;
        }
        this.deletedBlocksByType = new HashMap<Integer, Deque<DeletedBlock>>();
        for (BlockType value : BlockType.values()) {
            this.deletedBlocksByType.put(value.getId(), new ArrayDeque());
        }
        this.writerBlock = new ReferenceBlock(0L, null, 0, null);
        this.init();
    }

    private void init() {
        int index = 0;
        do {
            this.addBuffer(index);
        } while (this.getStoreFile(++index).exists());
    }

    private ReferenceBuffer addBuffer() {
        return this.addBuffer(this.buffers.length);
    }

    private ReferenceBuffer addBuffer(int index) {
        ReferenceBuffer buffer;
        this.currentBuffer = buffer = new ReferenceBuffer(this.getStoreFile(index), index);
        if (index == 0) {
            this.buffers = new ReferenceBuffer[1];
            this.buffers[0] = buffer;
        } else {
            ReferenceBuffer[] newBuffers = new ReferenceBuffer[index + 1];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = buffer;
            this.buffers = newBuffers;
        }
        return this.currentBuffer;
    }

    private File getStoreFile(int index) {
        return new File(this.path, this.name + "-" + index + ".rdx");
    }

    private ReferenceBlock reclaimOrCreateWriterBlock(BlockType blockType) {
        Deque<DeletedBlock> deletedBlocks = this.deletedBlocksByType.get(blockType.getId());
        if (deletedBlocks.size() > 0 && deletedBlocks.peekFirst().isAvailable(System.currentTimeMillis())) {
            DeletedBlock deletedBlock = deletedBlocks.poll();
            ReferenceBlock block = deletedBlock.getBlock();
            block.getBuffer().writeByte(blockType.getId(), block.getBlockPosition());
            return block;
        }
        if (this.currentBuffer.getRemainingSize() < blockType.getBlockSize()) {
            this.addBuffer();
        }
        this.currentBuffer.addBlock(this.writerBlock, blockType);
        return this.writerBlock;
    }

    private void deleteBlock(ReferenceBlock block) {
        block.getBuffer().writeByte(-1 * block.getBlockType().getId(), block.getBlockPosition());
        Deque<DeletedBlock> deletedBlocks = this.deletedBlocksByType.get(block.getBlockType().getId());
        if (deletedBlocks.size() < 100000) {
            deletedBlocks.offer(new DeletedBlock(block));
        }
    }

    @Override
    public long create(int value) {
        BlockType blockType = BlockType.SINGLE_ENTRY;
        ReferenceBlock block = this.reclaimOrCreateWriterBlock(blockType);
        block.getBuffer().writeInt(value, block.getBlockPosition() + 1);
        return block.getIndex();
    }

    @Override
    public long create(List<Integer> values) {
        BlockType blockType = BlockType.getEntryType(values.size());
        ReferenceBlock block = this.reclaimOrCreateWriterBlock(blockType);
        int len = Math.min(values.size(), blockType.getMaxEntries());
        Iterator<Integer> valueIterator = values.iterator();
        for (int i = 0; i < len; ++i) {
            block.addValue(valueIterator.next(), i * 4);
        }
        block.writeBlockEntryCount(len);
        if (blockType == BlockType.ENTRIES_4096_START) {
            block.writeStartBlockTotalCount(values.size());
            block.writeStartBlockNextIndex(0L);
            block.writeStartBlockLastIndex(0L);
        }
        if (len < values.size()) {
            ReferenceBlock startBlock;
            block = startBlock = this.addContinueBlocks(values, block, len, valueIterator);
        }
        return block.getIndex();
    }

    @Override
    public ReferenceBlock getBlock(long index) {
        if (index == 0L) {
            return null;
        }
        ReferenceBuffer buffer = this.getBufferForIndex(index);
        return buffer.getBlock(index);
    }

    private void setBlockData(long index, ReferenceBlock block) {
        ReferenceBuffer buffer = this.getBufferForIndex(index);
        buffer.setBlockData(index, block);
    }

    @Override
    public long add(int value, long index) {
        this.setBlockData(index, this.writerBlock);
        if (this.writerBlock.addValueIfRemainingSpace(value)) {
            if (this.writerBlock.getBlockType() == BlockType.ENTRIES_4096_START) {
                this.writerBlock.writeStartBlockTotalCount(this.writerBlock.getBlockEntryCount());
            }
            return index;
        }
        if (this.writerBlock.getBlockType().isSingleBlock()) {
            ReferenceBlock deletionBlock = this.writerBlock.copy();
            ReferenceBlock block = this.reclaimOrCreateWriterBlock(this.writerBlock.getBlockType().getNextSize());
            block.copyContent(deletionBlock);
            int entries = deletionBlock.getBlockType().getMaxEntries();
            block.addValue(value, entries * 4);
            block.writeBlockEntryCount(entries + 1);
            if (block.getBlockType() == BlockType.ENTRIES_4096_START) {
                block.writeStartBlockTotalCount(entries + 1);
                block.writeStartBlockNextIndex(0L);
                block.writeStartBlockLastIndex(0L);
            }
            this.deleteBlock(deletionBlock);
            return block.getIndex();
        }
        ReferenceBlock startBlock = this.writerBlock.copy();
        startBlock.writeStartBlockTotalCount(startBlock.getTotalEntryCount() + 1);
        long lastIndex = this.writerBlock.getStartBlockLastIndex();
        if (lastIndex == 0L) {
            this.writerBlock = this.reclaimOrCreateWriterBlock(BlockType.ENTRIES_4099_CONTINUE);
            this.writerBlock.addValue(value, 0);
            this.writerBlock.writeBlockEntryCount(1);
            startBlock.writeStartBlockNextIndex(this.writerBlock.getIndex());
            startBlock.writeStartBlockLastIndex(this.writerBlock.getIndex());
        } else {
            this.setBlockData(lastIndex, this.writerBlock);
            if (!this.writerBlock.addValueIfRemainingSpace(value)) {
                ReferenceBlock previousBlock = this.writerBlock.copy();
                this.writerBlock = this.reclaimOrCreateWriterBlock(BlockType.ENTRIES_4099_CONTINUE);
                previousBlock.writeNextIndex(this.writerBlock.getIndex());
                startBlock.writeStartBlockLastIndex(this.writerBlock.getIndex());
                this.writerBlock.addValue(value, 0);
                this.writerBlock.writeBlockEntryCount(1);
            }
        }
        return index;
    }

    @Override
    public long add(List<Integer> values, long index) {
        if (values.size() == 1) {
            return this.add(values.get(0), index);
        }
        this.setBlockData(index, this.writerBlock);
        if (this.writerBlock.getBlockType().isSingleBlock()) {
            int remainingEntries = this.writerBlock.getRemainingEntries();
            if (remainingEntries >= values.size()) {
                int blockEntries = this.writerBlock.getBlockEntryCount();
                int offset = blockEntries * 4;
                for (int i = 0; i < values.size(); ++i) {
                    this.writerBlock.addValue(values.get(i), offset + i * 4);
                }
                this.writerBlock.writeBlockEntryCount(blockEntries + values.size());
                return index;
            }
            int blockEntries = this.writerBlock.getBlockEntryCount();
            ReferenceBlock deletionBlock = this.writerBlock.copy();
            BlockType blockType = this.writerBlock.getBlockType().getNextSize(values.size());
            ReferenceBlock block = this.reclaimOrCreateWriterBlock(blockType);
            block.writeStartBlockTotalCount(blockEntries);
            block.copyContent(deletionBlock, blockEntries);
            index = block.getIndex();
            this.addValuesToBlockChain(values, block, blockType, blockEntries);
            this.deleteBlock(deletionBlock);
            return index;
        }
        ReferenceBlock block = this.writerBlock;
        BlockType blockType = block.getBlockType();
        assert (blockType == BlockType.ENTRIES_4096_START);
        int blockEntries = block.getBlockEntryCount();
        this.addValuesToBlockChain(values, block, blockType, blockEntries);
        return index;
    }

    private void addValuesToBlockChain(List<Integer> values, ReferenceBlock block, BlockType blockType, int blockEntries) {
        int len = Math.min(values.size(), blockType.getMaxEntries() - blockEntries);
        Iterator<Integer> valueIterator = values.iterator();
        int previousEntriesOffset = blockEntries * 4;
        for (int i = 0; i < len; ++i) {
            block.addValue(valueIterator.next(), previousEntriesOffset + i * 4);
        }
        block.writeBlockEntryCount(len + blockEntries);
        if (blockType == BlockType.ENTRIES_4096_START) {
            block.writeStartBlockTotalCount(block.getTotalEntryCount() + values.size());
            block.writeStartBlockNextIndex(0L);
            block.writeStartBlockLastIndex(0L);
        }
        if (len < values.size()) {
            this.addContinueBlocks(values, block, len, valueIterator);
        }
    }

    private ReferenceBlock addContinueBlocks(List<Integer> values, ReferenceBlock block, int len, Iterator<Integer> valueIterator) {
        ReferenceBlock startBlock = block.copy();
        boolean firstContinueBlock = true;
        for (int pos = len; pos < values.size(); pos += len) {
            ReferenceBlock previousBlock = block.copy();
            block = this.reclaimOrCreateWriterBlock(BlockType.ENTRIES_4099_CONTINUE);
            if (firstContinueBlock) {
                startBlock.writeStartBlockNextIndex(block.getIndex());
                firstContinueBlock = false;
            } else {
                previousBlock.writeNextIndex(block.getIndex());
            }
            len = Math.min(values.size() - pos, block.getBlockType().getMaxEntries());
            for (int i = 0; i < len; ++i) {
                block.addValue(valueIterator.next(), i * 4);
            }
            block.writeBlockEntryCount(len);
        }
        startBlock.writeStartBlockLastIndex(block.getIndex());
        return startBlock;
    }

    @Override
    public long remove(int deleteValue, long index) {
        return this.remove(Collections.singleton(deleteValue), index);
    }

    @Override
    public long remove(Set<Integer> deleteValues, long index) {
        ReferenceBlock block = this.getBlock(index);
        if (block.getBlockType().isSingleBlock()) {
            int dataPosition = block.getBlockDataPosition();
            int blockEntryCount = block.getBlockEntryCount();
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int i = 0; i < blockEntryCount; ++i) {
                int value = block.getBuffer().readInt(dataPosition + i * 4);
                if (deleteValues.contains(value)) continue;
                values.add(value);
            }
            if (blockEntryCount == values.size()) {
                return block.getIndex();
            }
            if (values.isEmpty()) {
                this.deleteBlock(block);
                return 0L;
            }
            BlockType blockType = BlockType.getEntryType(values.size());
            if (blockType.getId() > BlockType.ENTRIES_2.getId()) {
                int countDeleted = 0;
                for (int i = 0; i < blockEntryCount; ++i) {
                    int value = block.getBuffer().readInt(dataPosition + i * 4);
                    if (!deleteValues.contains(value)) continue;
                    block.getBuffer().writeInt(value * -1, dataPosition + i * 4);
                    ++countDeleted;
                }
                if (countDeleted > 0) {
                    block.writeBlockEntryCount(blockEntryCount - countDeleted);
                }
                return block.getIndex();
            }
            ReferenceBlock deleteBlock = block.copy();
            long newIndex = this.create(values);
            this.deleteBlock(deleteBlock);
            return newIndex;
        }
        int countTotalDeleted = 0;
        ReferenceBlock startBlock = block.copy();
        do {
            int dataPosition = block.getBlockDataPosition();
            int blockEntryCount = block.getBlockEntryCount();
            int countDeleted = 0;
            for (int i = 0; i < blockEntryCount; ++i) {
                int value = block.getBuffer().readInt(dataPosition + i * 4);
                if (!deleteValues.contains(value)) continue;
                block.getBuffer().writeInt(value * -1, dataPosition + i * 4);
                ++countDeleted;
            }
            if (countDeleted <= 0) continue;
            int entries = blockEntryCount - countDeleted;
            block.writeBlockEntryCount(entries);
            if (entries == 0) {
                // empty if block
            }
            countTotalDeleted += countDeleted;
        } while ((block = this.getBlock(block.getNextIndex())) != null);
        startBlock.writeStartBlockTotalCount(startBlock.getTotalEntryCount() - countTotalDeleted);
        return index;
    }

    @Override
    public void removeAll(long index) {
        ReferenceBlock block = this.getBlock(index);
        this.deleteBlock(block);
        if (!block.getBlockType().isSingleBlock()) {
            while (block.getNextIndex() != 0L) {
                long nextIndex = block.getNextIndex();
                block = this.getBlock(nextIndex);
                this.deleteBlock(block);
            }
        }
    }

    @Override
    public PrimitiveIterator.OfInt getReferences(long index) {
        ReferenceBlock block = this.getBlock(index);
        BlockType blockType = block.getBlockType();
        switch (blockType) {
            case SINGLE_ENTRY: {
                int value = block.getBuffer().readInt(block.getBlockDataPosition());
                return new SingleValueIterator(value);
            }
            case ENTRIES_2: {
                int value1 = block.getBuffer().readInt(block.getBlockDataPosition());
                int value2 = block.getBuffer().readInt(block.getBlockDataPosition() + 4);
                return new DoubleValueIterator(value1, value2);
            }
            case ENTRIES_4096_START: {
                return new ChainedBlockIterator(block, this);
            }
        }
        return new SingleBlockIterator(block);
    }

    @Override
    public int getReferencesCount(long index) {
        ReferenceBlock block = this.getBlock(index);
        return block.getTotalEntryCount();
    }

    private ReferenceBuffer getBufferForIndex(long index) {
        return this.buffers[MappedBuffer.getBufferIndex(index)];
    }

    @Override
    public void flush() {
        for (ReferenceBuffer buffer : this.buffers) {
            buffer.flush();
        }
    }

    @Override
    public void drop() {
        File file;
        int index = 0;
        while ((file = this.getStoreFile(index)).exists()) {
            ReferenceBuffer buffer = this.buffers[index];
            MappedStoreUtil.deleteBufferAndData(file, buffer.getAtomicBuffer());
            ++index;
        }
    }
}

