/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.nio.MappedByteBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.util.MappedStoreUtil;

public abstract class AbstractBufferIndex<TYPE, FILTER>
extends AbstractIndex<TYPE, FILTER> {
    private static final int ENTRIES_PER_BUCKET = 100000;
    private AtomicBuffer[] buffers;
    private int[] bufferEntryOffset;
    private int maximumId = -1;
    private int[] bucketToIndex;

    public AbstractBufferIndex(String name, TableIndex table, FullTextIndexingOptions fullTextIndexingOptions) {
        super(name, table, fullTextIndexingOptions);
        this.init();
    }

    private void init() {
        int index = 0;
        do {
            this.addBuffer();
        } while (this.getStoreFile(++index).exists());
    }

    protected abstract int getEntrySize();

    private void addBuffer() {
        int index = this.buffers == null ? 0 : this.buffers.length;
        int entries = this.getEntryCountForIndex(index);
        int bufferSize = entries * this.getEntrySize();
        int buckets = entries / 100000;
        AtomicBuffer buffer = MappedStoreUtil.createAtomicBuffer(this.getStoreFile(index), bufferSize);
        if (index == 0) {
            this.buffers = new AtomicBuffer[1];
            this.buffers[0] = buffer;
            this.bufferEntryOffset = new int[1];
            this.bufferEntryOffset[0] = entries;
        } else {
            AtomicBuffer[] newBuffers = new AtomicBuffer[index + 1];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = buffer;
            this.buffers = newBuffers;
            int[] newBufferEntryOffset = new int[index + 1];
            System.arraycopy(this.bufferEntryOffset, 0, newBufferEntryOffset, 0, this.bufferEntryOffset.length);
            newBufferEntryOffset[this.bufferEntryOffset.length] = this.bufferEntryOffset[this.bufferEntryOffset.length - 1] + entries;
            this.bufferEntryOffset = newBufferEntryOffset;
        }
        int startSize = this.bucketToIndex == null ? 0 : this.bucketToIndex.length;
        int newSize = startSize + buckets;
        int[] newBucketToIndex = new int[newSize];
        if (startSize > 0) {
            System.arraycopy(this.bucketToIndex, 0, newBucketToIndex, 0, startSize);
        }
        for (int i = startSize; i < newSize; ++i) {
            newBucketToIndex[i] = index;
        }
        this.bucketToIndex = newBucketToIndex;
        this.maximumId += entries;
    }

    protected void ensureBufferSize(int id) {
        if (id > this.maximumId) {
            while (this.maximumId < id) {
                this.addBuffer();
            }
        }
    }

    private File getStoreFile(int index) {
        return new File(this.getPath(), this.getName() + "-" + index + ".idx");
    }

    private int getEntryCountForIndex(int index) {
        index = Math.min(10, index);
        return (int)Math.pow(2.0, index) * 100000;
    }

    protected int getIndexForId(int id) {
        int bucket = id / 100000;
        return this.bucketToIndex[bucket];
    }

    protected int getOffsetForIndex(int index) {
        int offset = 0;
        if (index > 0) {
            offset = this.bufferEntryOffset[index - 1];
        }
        return offset;
    }

    protected AtomicBuffer getBuffer(int index) {
        return this.buffers[index];
    }

    public int getMaximumId() {
        return this.maximumId;
    }

    @Override
    public void close() {
        for (AtomicBuffer buffer : this.buffers) {
            MappedByteBuffer byteBuffer = (MappedByteBuffer)buffer.byteBuffer();
            byteBuffer.force();
        }
    }

    @Override
    public void drop() {
        int bufferIndex = 0;
        while (this.getStoreFile(bufferIndex).exists()) {
            try {
                File file = this.getStoreFile(bufferIndex);
                AtomicBuffer buffer = this.buffers[bufferIndex];
                MappedStoreUtil.deleteBufferAndData(file, buffer);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++bufferIndex;
        }
    }
}

