/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.bool;

import java.util.BitSet;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;

public class BitSetBooleanIndex
extends BooleanIndex {
    private BitSet bitSet = new BitSet();

    public BitSetBooleanIndex(String name, TableIndex table) {
        super(name, table);
        for (int i = 0; i <= this.getMaximumId() * 8; ++i) {
            this.bitSet.set(i, super.getValue(i));
        }
    }

    @Override
    public boolean getValue(int id) {
        return this.bitSet.get(id);
    }

    @Override
    public void setValue(int id, boolean value) {
        super.setValue(id, value);
        this.bitSet.set(id, value);
    }

    @Override
    public BitSet getBitSet() {
        return this.bitSet;
    }

    @Override
    public BitSet filterEquals(BitSet bitSet, boolean compare) {
        BitSet newBitSet = (BitSet)bitSet.clone();
        if (compare) {
            newBitSet.and(this.bitSet);
        } else {
            newBitSet.andNot(this.bitSet);
        }
        return newBitSet;
    }

    @Override
    public BitSet filterNotEquals(BitSet bitSet, boolean compare) {
        BitSet newBitSet = (BitSet)bitSet.clone();
        if (compare) {
            newBitSet.andNot(this.bitSet);
        } else {
            newBitSet.and(this.bitSet);
        }
        return newBitSet;
    }
}

