/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.teamapps.universaldb.index.file.FileUtil;
import org.teamapps.universaldb.index.fileng.FileValue;

public class LocalFileValue
implements FileValue {
    private final File file;
    private final String name;
    private final String hash;

    public LocalFileValue(File file) {
        this(file, file.getName());
    }

    public LocalFileValue(File file, String fileName) {
        this.file = file;
        this.name = fileName;
        this.hash = FileUtil.createFileHash(file);
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getFileName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public File getAsFile() {
        return this.file;
    }

    @Override
    public int getVersion() {
        return 0;
    }
}

