/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.universaldb.SchemaStats;
import org.teamapps.universaldb.distribute.ClusterSetConfig;
import org.teamapps.universaldb.distribute.TransactionExecutionResult;
import org.teamapps.universaldb.distribute.TransactionMaster;
import org.teamapps.universaldb.distribute.TransactionReader;
import org.teamapps.universaldb.distribute.TransactionWriter;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.SchemaIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileStore;
import org.teamapps.universaldb.index.file.LocalFileStore;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionIdHandler;
import org.teamapps.universaldb.transaction.TransactionRequest;
import org.teamapps.universaldb.transaction.TransactionStore;

public class UniversalDB
implements DataBaseMapper,
TransactionIdHandler {
    private static final ThreadLocal<Integer> THREAD_LOCAL_USER_ID = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Transaction> THREAD_LOCAL_TRANSACTION = new ThreadLocal();
    private final File storagePath;
    private final Map<Integer, DatabaseIndex> databaseById = new HashMap<Integer, DatabaseIndex>();
    private final Map<Integer, TableIndex> tableById = new HashMap<Integer, TableIndex>();
    private final Map<Integer, ColumnIndex> columnById = new HashMap<Integer, ColumnIndex>();
    private final SchemaIndex schemaIndex;
    private TransactionStore transactionStore;
    private SchemaStats schemaStats;
    private TransactionWriter transactionWriter;
    private TransactionReader transactionReader;
    private TransactionMaster transactionMaster;

    public static int getUserId() {
        return THREAD_LOCAL_USER_ID.get();
    }

    public static void setUserId(int userId) {
        THREAD_LOCAL_USER_ID.set(userId);
    }

    public static void startThreadLocalTransaction() {
        THREAD_LOCAL_TRANSACTION.set(Transaction.create());
    }

    public static Transaction getThreadLocalTransaction() {
        return THREAD_LOCAL_TRANSACTION.get();
    }

    public static void executeThreadLocalTransaction() {
        Transaction transaction = THREAD_LOCAL_TRANSACTION.get();
        transaction.execute();
        THREAD_LOCAL_TRANSACTION.set(null);
    }

    public static UniversalDB createStandalone(File storagePath, SchemaInfoProvider schemaInfoProvider) throws Exception {
        LocalFileStore fileStore = new LocalFileStore(new File(storagePath, "file-store"));
        return new UniversalDB(storagePath, schemaInfoProvider, fileStore);
    }

    public static UniversalDB createStandalone(File storagePath, SchemaInfoProvider schemaInfoProvider, FileStore fileStore) throws Exception {
        return new UniversalDB(storagePath, schemaInfoProvider, fileStore);
    }

    public static UniversalDB createClusterNode(File storagePath, SchemaInfoProvider schemaInfoProvider, ClusterSetConfig clusterConfig) throws Exception {
        LocalFileStore fileStore = new LocalFileStore(new File(storagePath, "file-store"));
        return new UniversalDB(storagePath, schemaInfoProvider, fileStore, clusterConfig);
    }

    private UniversalDB(File storagePath, SchemaInfoProvider schemaInfo, FileStore fileStore) throws Exception {
        this.storagePath = storagePath;
        this.transactionStore = new TransactionStore(storagePath);
        Transaction.setDataBase(this);
        Schema schema = Schema.parse(schemaInfo.getSchema());
        String pojoPath = schema.getPojoNamespace();
        this.schemaIndex = new SchemaIndex(schema, storagePath);
        this.schemaIndex.setFileStore(fileStore);
        this.mapSchema(schema);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            String path = pojoPath + "." + database.getName().toLowerCase();
            for (TableIndex table : database.getTables()) {
                String tableName = table.getName();
                String className = path + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
                Class<?> schemaClass = Class.forName(className);
                Method method = schemaClass.getDeclaredMethod("setTableIndex", TableIndex.class);
                method.setAccessible(true);
                method.invoke(null, table);
            }
        }
    }

    private void mapSchema(Schema schema) throws IOException {
        Schema localSchema = this.transactionStore.getSchema();
        if (localSchema != null) {
            if (!localSchema.isCompatibleWith(schema)) {
                throw new RuntimeException("Cannot load incompatible schema. Current schema is:\n" + schema + "\nNew schema is:\n" + localSchema);
            }
            localSchema.merge(schema);
            this.transactionStore.saveSchema(localSchema);
        } else {
            localSchema = schema;
            this.transactionStore.saveSchema(localSchema);
        }
        localSchema.mapSchema();
        this.schemaIndex.merge(localSchema);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            this.databaseById.put(database.getMappingId(), database);
            for (TableIndex table : database.getTables()) {
                this.tableById.put(table.getMappingId(), table);
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    this.columnById.put(columnIndex.getMappingId(), columnIndex);
                }
            }
        }
    }

    private UniversalDB(File storagePath, SchemaInfoProvider schemaInfo, FileStore fileStore, ClusterSetConfig clusterConfig) throws Exception {
        this.storagePath = storagePath;
        this.schemaStats = new SchemaStats(storagePath);
        Transaction.setDataBase(this);
        Schema schema = Schema.parse(schemaInfo.getSchema());
        String pojoPath = schema.getPojoNamespace();
        this.schemaIndex = new SchemaIndex(Schema.parse(schema.getPojoNamespace()), storagePath);
        this.schemaIndex.setFileStore(fileStore);
        this.mapSchemaForCluster(schema);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            String path = pojoPath + "." + database.getName().toLowerCase();
            for (TableIndex table : database.getTables()) {
                String tableName = table.getName();
                String className = path + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
                Class<?> schemaClass = Class.forName(className);
                Method method = schemaClass.getDeclaredMethod("setTableIndex", TableIndex.class);
                method.setAccessible(true);
                method.invoke(null, table);
            }
        }
        this.transactionWriter = new TransactionWriter(clusterConfig, this.schemaStats);
        this.transactionReader = new TransactionReader(clusterConfig, this.schemaStats, this, this.transactionWriter.getTransactionMap(), this);
        this.transactionMaster = new TransactionMaster(clusterConfig, this.schemaStats, this, this);
    }

    private void mapSchemaForCluster(Schema schema) throws IOException {
        Schema localSchema = this.schemaStats.getSchema();
        if (localSchema != null) {
            if (!localSchema.isCompatibleWith(schema)) {
                throw new RuntimeException("Cannot load incompatible schema. Current schema is:\n" + schema + "\nNew schema is:\n" + localSchema);
            }
            localSchema.merge(schema);
            this.schemaStats.saveSchema(localSchema);
        } else {
            localSchema = schema;
            this.schemaStats.saveSchema(localSchema);
        }
        localSchema.mapSchema();
        this.schemaIndex.merge(localSchema);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            this.databaseById.put(database.getMappingId(), database);
            for (TableIndex table : database.getTables()) {
                this.tableById.put(table.getMappingId(), table);
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    this.columnById.put(columnIndex.getMappingId(), columnIndex);
                }
            }
        }
    }

    public void executeTransaction(ClusterTransaction transaction, boolean asynchronous) throws IOException {
        if (this.transactionWriter != null) {
            this.executeClusterTransaction(transaction, asynchronous);
        } else {
            this.executeStandaloneTransaction(transaction);
        }
    }

    private synchronized void executeStandaloneTransaction(ClusterTransaction transaction) throws IOException {
        TransactionRequest request = transaction.createRequest();
        this.transactionStore.executeTransaction(request);
    }

    private void executeClusterTransaction(ClusterTransaction transaction, boolean asynchronous) throws IOException {
        TransactionExecutionResult transactionExecutionResult = this.transactionWriter.writeTransaction(transaction);
        if (!asynchronous) {
            transactionExecutionResult.waitForExecution();
        }
    }

    public void createDatabaseDump(File dumpFolder) throws IOException {
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            File dbFolder = new File(dumpFolder, database.getName());
            dbFolder.mkdir();
            for (TableIndex table : database.getTables()) {
                File tableFolder = new File(dbFolder, table.getName());
                tableFolder.mkdir();
                BitSet records = table.getRecords();
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    File dumpFile = new File(tableFolder, columnIndex.getName() + ".dbd");
                    columnIndex.dumpIndex(dumpFile, records);
                }
            }
        }
    }

    @Override
    public DatabaseIndex getDatabaseById(int mappingId) {
        return this.databaseById.get(mappingId);
    }

    @Override
    public TableIndex getCollectionIndexById(int mappingId) {
        return this.tableById.get(mappingId);
    }

    @Override
    public ColumnIndex getColumnById(int mappingId) {
        return this.columnById.get(mappingId);
    }

    @Override
    public long getAndCommitNextTransactionId() {
        if (this.schemaStats != null) {
            return this.schemaStats.getAndCommitNextTransactionId();
        }
        return this.transactionStore.getAndCommitNextTransactionId();
    }

    @Override
    public long getLastCommittedTransactionId() {
        if (this.schemaStats != null) {
            return this.schemaStats.getLastCommittedTransactionId();
        }
        return this.transactionStore.getLastCommittedTransactionId();
    }

    @Override
    public void commitTransactionId(long id) {
        if (this.schemaStats != null) {
            this.schemaStats.commitTransactionId(id);
        }
    }

    public SchemaStats getClusterSchemaStats() {
        return this.schemaStats;
    }

    public SchemaIndex getSchemaIndex() {
        return this.schemaIndex;
    }
}

