/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster.message;

import java.nio.ByteBuffer;
import org.teamapps.universaldb.cluster.ClusterNodeRole;
import org.teamapps.universaldb.cluster.ClusterOperationMode;
import org.teamapps.universaldb.cluster.message.ClusterMessage;
import org.teamapps.universaldb.cluster.network.MessageType;

public class ClusterNodeStatusMessage
implements ClusterMessage {
    private final int nodeId;
    private final long lastTransactionId;
    private final long currentTransactionId;
    private final long transactionCount;
    private final int transactionQueueSize;
    private final ClusterOperationMode clusterOperationMode;
    private final ClusterNodeRole currentType;
    private final ClusterNodeRole preferredType;
    private final int connectedNodes;
    private final int currentHead;
    private final byte[] data;

    public ClusterNodeStatusMessage(int nodeId, long lastTransactionId, long currentTransactionId, long transactionCount, int transactionQueueSize, ClusterOperationMode clusterOperationMode, ClusterNodeRole currentType, ClusterNodeRole preferredType, int connectedNodes, int currentHead) {
        this.nodeId = nodeId;
        this.lastTransactionId = lastTransactionId;
        this.currentTransactionId = currentTransactionId;
        this.transactionCount = transactionCount;
        this.transactionQueueSize = transactionQueueSize;
        this.clusterOperationMode = clusterOperationMode;
        this.currentType = currentType;
        this.preferredType = preferredType;
        this.connectedNodes = connectedNodes;
        this.currentHead = currentHead;
        this.data = new byte[43];
        ByteBuffer buffer = ByteBuffer.wrap(this.data);
        buffer.putInt(nodeId);
        buffer.putLong(lastTransactionId);
        buffer.putLong(currentTransactionId);
        buffer.putLong(transactionCount);
        buffer.putInt(transactionQueueSize);
        buffer.put((byte)clusterOperationMode.getId());
        buffer.put((byte)currentType.getId());
        buffer.put((byte)preferredType.getId());
        buffer.putInt(connectedNodes);
        buffer.putInt(currentHead);
    }

    public ClusterNodeStatusMessage(byte[] data) {
        this.data = data;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.nodeId = buffer.getInt();
        this.lastTransactionId = buffer.getLong();
        this.currentTransactionId = buffer.getLong();
        this.transactionCount = buffer.getLong();
        this.transactionQueueSize = buffer.getInt();
        this.clusterOperationMode = ClusterOperationMode.getById(buffer.get());
        this.currentType = ClusterNodeRole.getById(buffer.get());
        this.preferredType = ClusterNodeRole.getById(buffer.get());
        this.connectedNodes = buffer.getInt();
        this.currentHead = buffer.getInt();
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public long getLastTransactionId() {
        return this.lastTransactionId;
    }

    public long getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public int getTransactionQueueSize() {
        return this.transactionQueueSize;
    }

    public ClusterOperationMode getClusterOperationMode() {
        return this.clusterOperationMode;
    }

    public ClusterNodeRole getCurrentType() {
        return this.currentType;
    }

    public ClusterNodeRole getPreferredType() {
        return this.preferredType;
    }

    public int getConnectedNodes() {
        return this.connectedNodes;
    }

    public int getCurrentHead() {
        return this.currentHead;
    }

    @Override
    public MessageType getType() {
        return MessageType.CLUSTER_NODE_STATUS_UPDATE;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

