/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FileUtil {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final int MAX_CHARACTERS_CONTENT = 75000;

    public static void compressAndEncrypt(File src, File dst, String password) throws Exception {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst));
        SecureRandom secureRandom = new SecureRandom();
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        out.write(iv);
        out.flush();
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(FileUtil.createHashArray(password), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)keySpec, ivSpec);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(out, cipher);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(new BufferedOutputStream(cipherOutputStream));
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(src));
        byte[] buf = new byte[8096];
        int read = 0;
        while ((read = bis.read(buf)) >= 0) {
            deflaterOutputStream.write(buf, 0, read);
        }
        deflaterOutputStream.flush();
        cipherOutputStream.flush();
        out.flush();
        deflaterOutputStream.close();
        cipherOutputStream.close();
        out.close();
    }

    public static void decryptAndDecompress(File src, File dst, String password) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        byte[] iv = new byte[16];
        IOUtils.readFully((InputStream)in, (byte[])iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(FileUtil.createHashArray(password), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)keySpec, ivSpec);
        CipherInputStream cipherInputStream = new CipherInputStream(in, cipher);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new BufferedInputStream(cipherInputStream));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dst));
        byte[] buf = new byte[8096];
        int numRead = 0;
        while ((numRead = inflaterInputStream.read(buf)) >= 0) {
            bos.write(buf, 0, numRead);
        }
        bos.close();
        inflaterInputStream.close();
    }

    public static void decryptAndDecompress(InputStream src, File dst, String password) throws Exception {
        BufferedInputStream in = new BufferedInputStream(src);
        byte[] iv = new byte[16];
        IOUtils.readFully((InputStream)in, (byte[])iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(FileUtil.createHashArray(password), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)keySpec, ivSpec);
        CipherInputStream cipherInputStream = new CipherInputStream(in, cipher);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new BufferedInputStream(cipherInputStream));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dst));
        byte[] buf = new byte[8096];
        int numRead = 0;
        while ((numRead = inflaterInputStream.read(buf)) >= 0) {
            bos.write(buf, 0, numRead);
        }
        bos.close();
        inflaterInputStream.close();
    }

    public static void encrypt(File src, File dst, String password) throws Exception {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst));
        SecureRandom secureRandom = new SecureRandom();
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        out.write(iv);
        out.flush();
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(FileUtil.createHashArray(password), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)keySpec, ivSpec);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(out, cipher);
        BufferedOutputStream bos = new BufferedOutputStream(cipherOutputStream);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(src));
        byte[] buf = new byte[8096];
        int read = 0;
        while ((read = bis.read(buf)) >= 0) {
            bos.write(buf, 0, read);
        }
        bos.flush();
        cipherOutputStream.flush();
        out.flush();
        bos.close();
        cipherOutputStream.close();
        out.close();
    }

    public static void decrypt(InputStream src, File dst, String password) throws Exception {
        BufferedInputStream in = new BufferedInputStream(src);
        byte[] iv = new byte[16];
        IOUtils.readFully((InputStream)in, (byte[])iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(FileUtil.createHashArray(password), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)keySpec, ivSpec);
        CipherInputStream cipherInputStream = new CipherInputStream(in, cipher);
        BufferedInputStream bis = new BufferedInputStream(cipherInputStream);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dst));
        byte[] buf = new byte[8096];
        int numRead = 0;
        while ((numRead = bis.read(buf)) >= 0) {
            bos.write(buf, 0, numRead);
        }
        bos.close();
        bis.close();
    }

    public static Map<String, String> parseFileMetaData(InputStream inputStream) {
        HashedMap hashedMap;
        block13: {
            if (inputStream == null) {
                return null;
            }
            InputStream inputStream2 = inputStream;
            try {
                Metadata meta;
                HashedMap metaData;
                block12: {
                    metaData = new HashedMap();
                    BodyContentHandler handler = new BodyContentHandler(0);
                    meta = new Metadata();
                    BufferedInputStream bis = new BufferedInputStream(inputStream);
                    AutoDetectParser parser = new AutoDetectParser();
                    try {
                        parser.parse((InputStream)bis, (ContentHandler)handler, meta, new ParseContext());
                    }
                    catch (SAXException e) {
                        if (e.getClass().toString().contains("WriteLimitReachedException")) break block12;
                        throw e;
                    }
                }
                HashedMap propertyNames = meta.names();
                Arrays.sort((Object[])propertyNames);
                for (HashedMap name : propertyNames) {
                    String value = meta.get((String)name);
                    metaData.put(name, value);
                }
                hashedMap = metaData;
                if (inputStream2 == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            inputStream2.close();
        }
        return hashedMap;
    }

    public static String createFileHash(File file) {
        try {
            int count;
            byte[] buffer = new byte[8192];
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            while ((count = bis.read(buffer)) > 0) {
                digest.update(buffer, 0, count);
            }
            bis.close();
            byte[] hash = digest.digest();
            return FileUtil.bytesToHex(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String createHash(String ... values) {
        try {
            String value = Arrays.stream(values).collect(Collectors.joining("."));
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(bytes);
            return FileUtil.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing message digest:" + e.getMessage());
        }
    }

    private static byte[] createHashArray(String value) throws NoSuchAlgorithmException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(bytes);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void deleteFileRecursive(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileUtil.deleteFileRecursive(f);
            }
            try {
                file.delete();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            try {
                file.delete();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

