/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;

class SearchCollector
extends SimpleCollector {
    public static final String ID = "id";
    private NumericDocValues idValues;
    private final BitSet resultIds = new BitSet();

    public void collect(int doc) throws IOException {
        int id;
        if (this.idValues.advanceExact(doc) && (id = (int)this.idValues.longValue()) > 0) {
            this.resultIds.set(id);
        }
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.idValues = context.reader().getNumericDocValues(ID);
    }

    public BitSet getResultIds() {
        return this.resultIds;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

