/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.binary.BinaryIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.ReferenceIteratorValue;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.IndexPath;
import org.teamapps.universaldb.util.DataStreamUtil;

public interface ColumnIndex<TYPE, FILTER>
extends MappedObject {
    public static ColumnIndex createColumn(TableIndex table, String name, ColumnType columnType) {
        AbstractIndex column = null;
        switch (columnType.getIndexType()) {
            case BOOLEAN: {
                column = new BooleanIndex(name, table, columnType);
                break;
            }
            case SHORT: {
                column = new ShortIndex(name, table, columnType);
                break;
            }
            case INT: {
                column = new IntegerIndex(name, table, columnType);
                break;
            }
            case LONG: {
                column = new LongIndex(name, table, columnType);
                break;
            }
            case FLOAT: {
                column = new FloatIndex(name, table, columnType);
                break;
            }
            case DOUBLE: {
                column = new DoubleIndex(name, table, columnType);
                break;
            }
            case TEXT: {
                column = new TextIndex(name, table, columnType, table.getCollectionTextSearchIndex());
                break;
            }
            case TRANSLATABLE_TEXT: {
                column = new TranslatableTextIndex(name, table, columnType, table.getCollectionTextSearchIndex());
                break;
            }
            case REFERENCE: {
                column = new SingleReferenceIndex(name, table, columnType);
                break;
            }
            case MULTI_REFERENCE: {
                column = new MultiReferenceIndex(name, table, columnType);
                break;
            }
            case FILE: {
                column = new FileIndex(name, table, columnType, FullTextIndexingOptions.INDEXED, table.getCollectionTextSearchIndex(), table.getFileStore());
                break;
            }
            case BINARY: {
                column = new BinaryIndex(name, table, false, columnType);
            }
        }
        return column;
    }

    default public String getStringValue(int id) {
        TYPE value = this.getGenericValue(id);
        if (value == null) {
            return "NULL";
        }
        switch (this.getType()) {
            case MULTI_REFERENCE: {
                ReferenceIteratorValue referenceIteratorValue = (ReferenceIteratorValue)value;
                return "(" + referenceIteratorValue.getAsList().stream().limit(100L).map(v -> "" + v).collect(Collectors.joining(", ")) + ")";
            }
            case FILE: {
                FileValue fileValue = (FileValue)value;
                if (fileValue.getMetaData() != null) {
                    return fileValue.getMetaData().getName() + " (" + fileValue.getMetaData().getSize() + ")";
                }
                return fileValue.getUuid();
            }
            case BINARY: {
                byte[] byteValue = (byte[])value;
                return byteValue.length + " bytes";
            }
        }
        return value.toString();
    }

    public String getName();

    public TableIndex getTable();

    public ColumnType getColumnType();

    @Override
    public String getFQN();

    public IndexType getType();

    public FullTextIndexingOptions getFullTextIndexingOptions();

    @Override
    public int getMappingId();

    @Override
    public void setMappingId(int var1);

    public TYPE getGenericValue(int var1);

    public void setGenericValue(int var1, TYPE var2);

    public void removeValue(int var1);

    public void writeTransactionValue(TYPE var1, DataOutputStream var2) throws IOException;

    public TYPE readTransactionValue(DataInputStream var1) throws IOException;

    default public ColumnIndex getReferencedColumn() {
        return null;
    }

    default public IndexFilter<TYPE, FILTER> createFilter(FILTER filter) {
        return new IndexFilter(this, filter);
    }

    default public IndexFilter<TYPE, FILTER> createFilter(FILTER filter, IndexPath indexPath) {
        return new IndexFilter(this, filter, indexPath);
    }

    default public void writeSchema(DataOutputStream dataOutputStream) throws IOException {
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, this.getName());
        dataOutputStream.writeInt(this.getType().getId());
        dataOutputStream.writeInt(this.getMappingId());
    }

    public List<SortEntry> sortRecords(List<SortEntry> var1, boolean var2, UserContext var3);

    public BitSet filter(BitSet var1, FILTER var2);

    default public void dumpIndex(File file, BitSet records) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 128000));
        this.dumpIndex(dataOutputStream, records);
        dataOutputStream.close();
    }

    public void dumpIndex(DataOutputStream var1, BitSet var2) throws IOException;

    default public void restoreIndex(File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file), 128000));
        this.restoreIndex(dataInputStream);
        dataInputStream.close();
    }

    public void restoreIndex(DataInputStream var1) throws IOException;

    public void close();

    public void drop();
}

