/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.text.FullTextIndexValue;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class TransactionRecord {
    private static final Logger log = LoggerFactory.getLogger(TransactionRecord.class);
    private final TableIndex tableIndex;
    private int recordId;
    private final boolean update;
    private final boolean deleteRecord;
    private final boolean restoreRecord;
    private final int correlationId;
    private final long recordTransactionId;
    private List<TransactionRecordValue> recordValues;
    private boolean transactionProcessingStarted = false;

    public static TransactionRecord createOrUpdateRecord(TableIndex tableIndex, int recordId, int correlationId, int userId, boolean update, boolean strictChangeVerification) {
        return new TransactionRecord(tableIndex, recordId, correlationId, userId, update, false, strictChangeVerification, false);
    }

    public static TransactionRecord deleteRecord(TableIndex tableIndex, int recordId, int userId) {
        return new TransactionRecord(tableIndex, recordId, 0, userId, false, true, false, false);
    }

    public static TransactionRecord restoreRecord(TableIndex tableIndex, int recordId, int userId) {
        return new TransactionRecord(tableIndex, recordId, 0, userId, false, false, false, true);
    }

    private TransactionRecord(TableIndex tableIndex, int recordId, int correlationId, int userId, boolean update, boolean deleteRecord, boolean strictChangeVerification, boolean restoreRecord) {
        this.tableIndex = tableIndex;
        this.recordId = recordId;
        this.correlationId = correlationId;
        this.update = update;
        this.deleteRecord = deleteRecord;
        this.restoreRecord = restoreRecord;
        this.recordTransactionId = strictChangeVerification ? tableIndex.getTransactionId(recordId) : 0L;
        this.recordValues = new ArrayList<TransactionRecordValue>();
        if (deleteRecord) {
            if (recordId <= 0) {
                throw new RuntimeException("Cannot delete record with no record id");
            }
            this.setDeletionData(userId);
        } else if (restoreRecord) {
            if (recordId <= 0) {
                throw new RuntimeException("Cannot restore record with no record id");
            }
            this.setRestoreData(userId);
        } else {
            this.setModificationData(tableIndex, update, userId);
        }
    }

    private void setModificationData(TableIndex tableIndex, boolean update, int userId) {
        TableConfig config = tableIndex.getTableConfig();
        int changeDate = (int)(System.currentTimeMillis() / 1000L);
        if (!update) {
            if (config.trackCreation()) {
                this.addRecordValue(tableIndex.getColumnIndex("metaCreationDate"), changeDate);
                this.addRecordValue(tableIndex.getColumnIndex("metaCreatedBy"), userId);
            }
            if (config.trackModification()) {
                this.addRecordValue(tableIndex.getColumnIndex("metaModificationDate"), changeDate);
                this.addRecordValue(tableIndex.getColumnIndex("metaModifiedBy"), userId);
            }
        } else if (config.trackModification()) {
            this.addRecordValue(tableIndex.getColumnIndex("metaModificationDate"), changeDate);
            this.addRecordValue(tableIndex.getColumnIndex("metaModifiedBy"), userId);
        }
    }

    private void setDeletionData(int userId) {
        TableConfig config = this.tableIndex.getTableConfig();
        if (config.keepDeleted()) {
            this.addRecordValue(this.tableIndex.getColumnIndex("metaDeletionDate"), (int)(System.currentTimeMillis() / 1000L));
            this.addRecordValue(this.tableIndex.getColumnIndex("metaDeletedBy"), userId);
        }
    }

    private void setRestoreData(int userId) {
        TableConfig config = this.tableIndex.getTableConfig();
        if (config.keepDeleted()) {
            this.addRecordValue(this.tableIndex.getColumnIndex("metaRestoreDate"), (int)(System.currentTimeMillis() / 1000L));
            this.addRecordValue(this.tableIndex.getColumnIndex("metaRestoredBy"), userId);
        }
    }

    public TransactionRecord(DataInputStream dis, DataBaseMapper dataBaseMapper) throws IOException {
        this.tableIndex = dataBaseMapper.getCollectionIndexById(dis.readInt());
        this.recordId = dis.readInt();
        this.correlationId = dis.readInt();
        this.update = dis.readBoolean();
        this.deleteRecord = dis.readBoolean();
        this.restoreRecord = dis.readBoolean();
        this.recordTransactionId = dis.readLong();
        this.recordValues = new ArrayList<TransactionRecordValue>();
        int valueCount = dis.readInt();
        for (int i = 0; i < valueCount; ++i) {
            this.recordValues.add(new TransactionRecordValue(dis, dataBaseMapper));
        }
    }

    public void addRecordValue(ColumnIndex column, Object value) {
        this.addRecordValue(new TransactionRecordValue(column, value));
    }

    public void addRecordValue(TransactionRecordValue recordValue) {
        this.recordValues.add(recordValue);
    }

    public int getRecordId() {
        return this.recordId;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public List<TransactionRecordValue> getRecordValues() {
        return this.recordValues;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isDeleteRecord() {
        return this.deleteRecord;
    }

    public long getRecordTransactionId() {
        return this.recordTransactionId;
    }

    public void writeTransactionValue(DataOutputStream dos) throws IOException {
        dos.writeInt(this.tableIndex.getMappingId());
        dos.writeInt(this.recordId);
        dos.writeInt(this.correlationId);
        dos.writeBoolean(this.update);
        dos.writeBoolean(this.deleteRecord);
        dos.writeBoolean(this.restoreRecord);
        dos.writeLong(this.recordTransactionId);
        dos.writeInt(this.recordValues.size());
        for (TransactionRecordValue recordValue : this.recordValues) {
            recordValue.writeTransactionValue(dos);
        }
    }

    public boolean checkUnchangedRecordTransactionId() {
        if (this.recordTransactionId == 0L || this.recordId == 0) {
            return true;
        }
        return this.recordTransactionId == this.tableIndex.getTransactionId(this.recordId);
    }

    public void createIfNotExists(Map<Integer, Integer> recordIdByCorrelationId) {
        if (!this.deleteRecord && !this.restoreRecord) {
            boolean updateMap = this.recordId == 0;
            this.recordId = this.tableIndex.createRecord(this.recordId, this.correlationId, this.update);
            if (updateMap) {
                recordIdByCorrelationId.put(this.correlationId, this.recordId);
            }
        }
    }

    public void persistChanges(long transactionId, Map<Integer, Integer> recordIdByCorrelationId) {
        if (this.transactionProcessingStarted) {
            return;
        }
        this.transactionProcessingStarted = true;
        if (this.deleteRecord) {
            this.tableIndex.deleteRecord(this.recordId);
        } else if (this.restoreRecord) {
            this.tableIndex.restoreRecord(this.recordId);
        } else if (this.recordId == 0) {
            log.error("ERROR!: could not save record - record id == 0:" + this.tableIndex.getFQN());
            return;
        }
        this.processColumnChanges(transactionId, recordIdByCorrelationId);
    }

    public void persistResolvedChanges(long transactionId, Map<Integer, Integer> recordIdByCorrelationId) {
        if (this.deleteRecord) {
            this.tableIndex.deleteRecord(this.recordId);
        } else if (this.restoreRecord) {
            this.tableIndex.restoreRecord(this.recordId);
        } else {
            if (this.recordId == 0) {
                this.recordId = recordIdByCorrelationId.get(this.correlationId);
                if (this.recordId == 0) {
                    log.error("ERROR!: could not resolve recordId by correlationId for table:" + this.tableIndex.getFQN());
                    return;
                }
            }
            this.recordId = this.tableIndex.createRecord(this.recordId, this.correlationId, this.update);
        }
        this.processColumnChanges(transactionId, recordIdByCorrelationId);
    }

    public void processColumnChanges(long transactionId, Map<Integer, Integer> recordIdByCorrelationId) {
        List<FullTextIndexValue> fullTextIndexValues;
        this.tableIndex.setTransactionId(this.recordId, transactionId);
        for (TransactionRecordValue recordValue : this.recordValues) {
            recordValue.persistChange(this.recordId, recordIdByCorrelationId);
        }
        if (!(this.deleteRecord || this.restoreRecord || (fullTextIndexValues = this.recordValues.stream().filter(value -> value.getColumn().getType() == IndexType.TEXT || value.getColumn().getType() == IndexType.TRANSLATABLE_TEXT).map(value -> {
            if (value.getColumn().getType() == IndexType.TEXT) {
                return new FullTextIndexValue(value.getColumn().getName(), (String)value.getValue());
            }
            return new FullTextIndexValue(value.getColumn().getName(), (TranslatableText)value.getValue());
        }).collect(Collectors.toList())).isEmpty())) {
            this.tableIndex.updateFullTextIndex(this.recordId, fullTextIndexValues, this.update);
        }
    }
}

