/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster;

import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.cluster.ClusterNodeConfig;

public class ClusterConfig {
    private final String clusterSecret;
    private final List<ClusterNodeConfig> clusterNodes;
    private final int localNodeId;

    public ClusterConfig(String clusterSecret, List<ClusterNodeConfig> clusterNodes, int localNodeId) {
        this.clusterSecret = clusterSecret;
        this.clusterNodes = clusterNodes;
        this.localNodeId = localNodeId;
    }

    public ClusterConfig copy(int localNodeId) {
        return new ClusterConfig(this.clusterSecret, this.clusterNodes, localNodeId);
    }

    public List<ClusterNodeConfig> getClusterNodes() {
        return this.clusterNodes;
    }

    public List<ClusterNodeConfig> getRemoteNodes() {
        return this.clusterNodes.stream().filter(node -> node.getNodeId() != this.localNodeId).collect(Collectors.toList());
    }

    public ClusterNodeConfig getLocalNode() {
        return this.clusterNodes.stream().filter(node -> node.getNodeId() == this.localNodeId).findFirst().orElse(null);
    }

    public String getClusterSecret() {
        return this.clusterSecret;
    }

    public int getLocalNodeId() {
        return this.localNodeId;
    }
}

