/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.distribute;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PacketDataMingling {
    private static MessageDigest md;
    private static Charset UTF8;

    public static synchronized byte[] getMD5(String value) {
        md.reset();
        md.update(value.getBytes(UTF8));
        return md.digest();
    }

    public static byte[] mingle(byte[] bytes, String sharedSecret, long salt) {
        if (bytes == null) {
            return null;
        }
        byte[] key = PacketDataMingling.getMD5(salt + sharedSecret);
        return PacketDataMingling.mingle(bytes, key);
    }

    public static byte[] mingle(byte[] bytes, byte[] key) {
        int Si;
        int i;
        byte[] result = new byte[bytes.length];
        int[] S = new int[256];
        for (i = 0; i < 256; ++i) {
            S[i] = i;
        }
        int j = 0;
        int ki = 0;
        for (i = 0; i < 256; ++i) {
            Si = S[i];
            j = j + Si + key[ki] & 0xFF;
            S[i] = S[j];
            S[j] = Si;
            if (++ki != key.length) continue;
            ki = 0;
        }
        int is = 0;
        int js = 0;
        int inLen = bytes.length;
        int outOfs = 0;
        int inOfs = 0;
        while (inLen-- > 0) {
            int Sj;
            is = is + 1 & 0xFF;
            Si = S[is];
            js = js + Si & 0xFF;
            S[is] = Sj = S[js];
            S[js] = Si;
            result[outOfs++] = (byte)(bytes[inOfs++] ^ S[Si + Sj & 0xFF]);
        }
        return result;
    }

    static {
        UTF8 = Charset.forName("UTF8");
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

