/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;

public class TransactionRecordValue {
    private final ColumnIndex column;
    private final Object value;

    public TransactionRecordValue(ColumnIndex column, Object value) {
        this.column = column;
        this.value = value;
    }

    public TransactionRecordValue(DataInputStream dataInputStream, DataBaseMapper dataBaseMapper) throws IOException {
        this.column = dataBaseMapper.getColumnById(dataInputStream.readInt());
        byte type = dataInputStream.readByte();
        this.value = type == 0 ? null : this.column.readTransactionValue(dataInputStream);
    }

    public ColumnIndex getColumn() {
        return this.column;
    }

    public Object getValue() {
        return this.value;
    }

    public int getColumnMappingId() {
        return this.column.getMappingId();
    }

    public void writeTransactionValue(DataOutputStream dataOutputStream) throws IOException {
        if (this.value == null) {
            dataOutputStream.writeInt(this.column.getMappingId());
            dataOutputStream.writeByte(0);
        } else {
            this.column.writeTransactionValue(this.value, dataOutputStream);
        }
    }

    public void persistChange(int id, Map<Integer, Integer> recordIdByCorrelationId) {
        if (this.column.getType() == IndexType.MULTI_REFERENCE) {
            MultiReferenceEditValue editValue = (MultiReferenceEditValue)this.value;
            this.updateReferences(recordIdByCorrelationId, editValue.getAddReferences());
            this.updateReferences(recordIdByCorrelationId, editValue.getRemoveReferences());
            this.updateReferences(recordIdByCorrelationId, editValue.getSetReferences());
            this.column.setGenericValue(id, editValue);
        } else if (this.column.getType() == IndexType.REFERENCE) {
            if (this.value != null) {
                RecordReference recordReference = (RecordReference)this.value;
                if (recordReference.getRecordId() == 0) {
                    int recordId = recordIdByCorrelationId.get(recordReference.getCorrelationId());
                    recordReference.setRecordId(recordId);
                }
                this.column.setGenericValue(id, recordReference);
            } else {
                this.column.setGenericValue(id, null);
            }
        } else {
            this.column.setGenericValue(id, this.value);
        }
    }

    public void updateReferences(Map<Integer, Integer> recordIdByCorrelationId, List<RecordReference> references) {
        references.forEach(reference -> {
            if (reference.getRecordId() == 0) {
                int recordId = (Integer)recordIdByCorrelationId.get(reference.getCorrelationId());
                reference.setRecordId(recordId);
            }
        });
    }
}

