/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.translation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.buffer.BlockEntryAtomicStore;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.TextFieldFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextSearchIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.transaction.DataType;
import org.teamapps.universaldb.util.DataStreamUtil;

public class TranslatableTextIndex
extends AbstractIndex<TranslatableText, TextFilter> {
    private BlockEntryAtomicStore atomicStore;
    private final TextSearchIndex searchIndex;
    private final CollectionTextSearchIndex collectionSearchIndex;

    public TranslatableTextIndex(String name, TableIndex table, ColumnType columnType, CollectionTextSearchIndex collectionSearchIndex) {
        super(name, table, columnType, FullTextIndexingOptions.INDEXED);
        this.atomicStore = new BlockEntryAtomicStore(table.getDataPath(), name);
        this.searchIndex = null;
        this.collectionSearchIndex = collectionSearchIndex;
    }

    public TranslatableTextIndex(String name, TableIndex table, ColumnType columnType, boolean withLocalSearchIndex) {
        super(name, table, columnType, withLocalSearchIndex ? FullTextIndexingOptions.INDEXED : FullTextIndexingOptions.NOT_INDEXED);
        this.atomicStore = new BlockEntryAtomicStore(table.getDataPath(), name);
        this.searchIndex = withLocalSearchIndex ? new TextSearchIndex(this.getFullTextIndexPath(), name) : null;
        this.collectionSearchIndex = null;
    }

    public CollectionTextSearchIndex getCollectionSearchIndex() {
        return this.collectionSearchIndex;
    }

    public boolean isFilteredByCollectionTextIndex(TextFilter filter) {
        return this.collectionSearchIndex != null && filter.getFilterType().containsFullTextPart();
    }

    public boolean isFilteredExclusivelyByCollectionTextIndex(TextFilter filter) {
        return this.collectionSearchIndex != null && filter.getFilterType().isFullTextIndexExclusive();
    }

    @Override
    public IndexType getType() {
        return IndexType.TRANSLATABLE_TEXT;
    }

    @Override
    public TranslatableText getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, TranslatableText value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, null);
    }

    public String getTranslatedValue(int id, String language) {
        TranslatableText value = this.getValue(id);
        return value != null ? value.translationLookup(language) : null;
    }

    public String getTranslatedValue(int id, List<String> languages) {
        TranslatableText value = this.getValue(id);
        return value != null ? value.getTranslation(languages) : null;
    }

    public TranslatableText getValue(int id) {
        String text = this.atomicStore.getText(id);
        return text != null ? new TranslatableText(text) : null;
    }

    public void setValue(int id, TranslatableText value) {
        boolean update = !this.atomicStore.isEmpty(id);
        String encodedValue = value != null ? value.getEncodedValue() : null;
        this.atomicStore.setText(id, encodedValue);
        if (this.searchIndex != null) {
            if (value != null) {
                this.searchIndex.addValue(id, value, update);
            } else {
                this.searchIndex.removeValue(id);
            }
        }
    }

    @Override
    public void writeTransactionValue(TranslatableText value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.STRING.getId());
        value.writeValues(dataOutputStream);
    }

    @Override
    public TranslatableText readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return new TranslatableText(dataInputStream);
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            TranslatableText value = this.getValue(id);
            dataOutputStream.writeInt(id);
            DataStreamUtil.writeTranslatableText(dataOutputStream, value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            TranslatableText value = DataStreamUtil.readTranslatableText(dataInputStream);
            this.setValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public BitSet filter(BitSet records, TextFilter textFilter) {
        return this.filter(records, textFilter, true);
    }

    @Override
    public void close() {
        if (this.searchIndex != null) {
            this.searchIndex.commit(true);
        }
        this.atomicStore.close();
    }

    @Override
    public void drop() {
        if (this.searchIndex != null) {
            this.searchIndex.drop();
        }
        this.atomicStore.drop();
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        String language = userContext.getLanguage();
        Comparator<String> comparator = UserContext.getOrCreateComparator(userContext, ascending);
        sortEntries.sort((o1, o2) -> comparator.compare(this.getTranslatedValue(o1.getLeafId(), language), this.getTranslatedValue(o2.getLeafId(), language)));
        return sortEntries;
    }

    public BitSet filter(BitSet records, TextFilter textFilter, boolean performLocalFullTextSearch) {
        BitSet fullTextResult = records;
        if (performLocalFullTextSearch && textFilter.getFilterType().containsFullTextPart()) {
            if (this.searchIndex != null) {
                fullTextResult = this.searchIndex.filter(records, textFilter);
            } else if (this.collectionSearchIndex != null) {
                fullTextResult = this.collectionSearchIndex.filter(records, Collections.singletonList(TextFieldFilter.create(textFilter, this.getName())), true);
            } else {
                return null;
            }
            if (!textFilter.getFilterType().containsIndexPart()) {
                return fullTextResult;
            }
        }
        if (textFilter.getFilterType().containsIndexPart()) {
            switch (textFilter.getFilterType()) {
                case EMPTY: {
                    return this.filterEmpty(records);
                }
                case NOT_EMPTY: {
                    return this.filterNotEmpty(records);
                }
                case TEXT_EQUALS: {
                    return this.filterEquals(fullTextResult, textFilter.getValue(), textFilter.getRankedLanguages());
                }
                case TEXT_NOT_EQUALS: {
                    return this.filterNotEquals(fullTextResult, textFilter.getValue(), textFilter.getRankedLanguages());
                }
                case TEXT_BYTE_LENGTH_GREATER: {
                    return this.filterLengthGreater(records, Integer.parseInt(textFilter.getValue()));
                }
                case TEXT_BYTE_LENGTH_SMALLER: {
                    return this.filterLengthSmaller(records, Integer.parseInt(textFilter.getValue()));
                }
            }
            return null;
        }
        return null;
    }

    public BitSet filterEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (this.atomicStore.isEmpty(id)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            if (!this.atomicStore.isEmpty(id)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterLengthGreater(BitSet bitSet, int length) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int blockLength = this.atomicStore.getBlockLength(id);
            if (blockLength > length) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterLengthSmaller(BitSet bitSet, int length) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int blockLength = this.atomicStore.getBlockLength(id);
            if (blockLength < length) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterEquals(BitSet bitSet, String value, List<String> rankedLanguages) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            TranslatableText translatableText = this.getValue(id);
            if (translatableText != null) {
                Map<String, String> translationMap = translatableText.getTranslationMap();
                for (String language : rankedLanguages) {
                    if (!Objects.equals(value, translationMap.get(language))) continue;
                    result.set(id);
                    break;
                }
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterNotEquals(BitSet bitSet, String value, List<String> rankedLanguages) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            TranslatableText translatableText = this.getValue(id);
            if (translatableText != null) {
                Map<String, String> translationMap = translatableText.getTranslationMap();
                boolean containsValue = false;
                for (String language : rankedLanguages) {
                    if (!Objects.equals(value, translationMap.get(language))) continue;
                    containsValue = true;
                    break;
                }
                if (!containsValue) {
                    result.set(id);
                }
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

