/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.IndexMetaData;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.file.FileStore;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.reference.ReferenceIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.FullTextIndexValue;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.index.versioning.RecordVersioningIndex;
import org.teamapps.universaldb.query.AndFilter;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.OrFilter;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Table;

public class TableIndex
implements MappedObject {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DatabaseIndex databaseIndex;
    private final Table table;
    private final String name;
    private final String parentFQN;
    private final File dataPath;
    private final File fullTextIndexPath;
    private final TableConfig tableConfig;
    private boolean keepDeletedRecords;
    private final BooleanIndex records;
    private BooleanIndex deletedRecords;
    private LongIndex transactionIndex;
    private final List<ColumnIndex> columnIndices;
    private final Map<String, ColumnIndex> columnIndexByName;
    private CollectionTextSearchIndex collectionTextSearchIndex;
    private List<String> fileFieldNames;
    private List<TextIndex> textFields;
    private List<TranslatableTextIndex> translatedTextFields;
    private int mappingId;
    private IndexMetaData indexMetaData;
    private RecordVersioningIndex recordVersioningIndex;
    private long lastFullTextIndexCheck;

    public TableIndex(DatabaseIndex database, Table table, TableConfig tableConfig) {
        this(database, database.getFQN(), table, tableConfig);
    }

    public TableIndex(DatabaseIndex databaseIndex, String parentFQN, Table table, TableConfig tableConfig) {
        this.databaseIndex = databaseIndex;
        this.table = table;
        this.name = table.getName();
        this.parentFQN = parentFQN;
        this.dataPath = new File(databaseIndex.getDataPath(), this.name);
        this.fullTextIndexPath = new File(databaseIndex.getFullTextIndexPath(), this.name);
        this.dataPath.mkdir();
        this.fullTextIndexPath.mkdir();
        this.records = new BooleanIndex("coll-recs", this, ColumnType.BOOLEAN);
        this.tableConfig = tableConfig;
        this.columnIndices = new ArrayList<ColumnIndex>();
        this.columnIndexByName = new HashMap<String, ColumnIndex>();
        if (tableConfig.keepDeleted()) {
            this.keepDeletedRecords = true;
            this.deletedRecords = new BooleanIndex("coll-del-recs", this, ColumnType.BOOLEAN);
        }
        this.indexMetaData = new IndexMetaData(this.dataPath, this.name, this.getFQN(), 0);
        this.mappingId = this.indexMetaData.getMappingId();
        this.recordVersioningIndex = new RecordVersioningIndex(this);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public CollectionTextSearchIndex getCollectionTextSearchIndex() {
        if (this.collectionTextSearchIndex == null) {
            this.collectionTextSearchIndex = new CollectionTextSearchIndex(this.fullTextIndexPath, "coll-text");
        }
        return this.collectionTextSearchIndex;
    }

    public void checkFullTextIndex() {
        if (this.collectionTextSearchIndex == null) {
            return;
        }
        if (!this.records.getValue(0) && this.getCount() > 0 && System.currentTimeMillis() - this.lastFullTextIndexCheck > 300000L || this.getCount() > 0 && this.collectionTextSearchIndex.getMaxDoc() == 0) {
            long time = System.currentTimeMillis();
            logger.warn("RECREATING FULL TEXT INDEX FOR: " + this.getName() + " (RECORDS:" + this.getCount() + ", MAX-DOC:" + this.collectionTextSearchIndex.getMaxDoc() + ")");
            this.recreateFullTextIndex();
            this.lastFullTextIndexCheck = System.currentTimeMillis();
            logger.warn("RECREATING FINISHED FOR: " + this.getName() + " (TIME:" + (System.currentTimeMillis() - time) + ")");
        }
        this.records.setValue(0, false);
    }

    public void forceFullTextIndexRecreation() {
        logger.warn("FORCED RECREATING FULL TEXT INDEX FOR: " + this.getName() + " (RECORDS:" + this.getCount() + ", MAX-DOC:" + this.collectionTextSearchIndex.getMaxDoc() + ")");
        this.recreateFullTextIndex();
    }

    private void recreateFullTextIndex() {
        try {
            this.collectionTextSearchIndex.deleteAllDocuments();
            BitSet bitSet = this.records.getBitSet();
            int id = bitSet.nextSetBit(0);
            while (id >= 0) {
                Object value;
                ArrayList<FullTextIndexValue> values = new ArrayList<FullTextIndexValue>();
                for (TextIndex textField : this.getTextFields()) {
                    value = textField.getValue(id);
                    if (value == null) continue;
                    values.add(new FullTextIndexValue(textField.getName(), (String)value));
                }
                for (TranslatableTextIndex translatableTextIndex : this.getTranslatedTextFields()) {
                    value = translatableTextIndex.getValue(id);
                    if (value == null) continue;
                    values.add(new FullTextIndexValue(translatableTextIndex.getName(), (TranslatableText)value));
                }
                if (!values.isEmpty()) {
                    this.collectionTextSearchIndex.setRecordValues(id, values, false);
                }
                id = bitSet.nextSetBit(id + 1);
            }
            this.collectionTextSearchIndex.commit(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Table getTable() {
        return this.table;
    }

    public FileStore getFileStore() {
        return this.databaseIndex.getSchemaIndex().getFileStore();
    }

    public RecordVersioningIndex getRecordVersioningIndex() {
        return this.recordVersioningIndex;
    }

    public File getDataPath() {
        return this.dataPath;
    }

    public File getFullTextIndexPath() {
        return this.fullTextIndexPath;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public BitSet getRecords() {
        return this.records.getBitSet();
    }

    public boolean isStored(int id) {
        return this.records.getValue(id);
    }

    public int getCount() {
        return this.records.getCount();
    }

    public BitSet getDeletedRecords() {
        if (!this.keepDeletedRecords) {
            return null;
        }
        return this.deletedRecords.getBitSet();
    }

    public int getDeletedRecordsCount() {
        return this.keepDeletedRecords ? this.deletedRecords.getCount() : 0;
    }

    public boolean isDeleted(int id) {
        if (this.deletedRecords != null) {
            return this.deletedRecords.getValue(id);
        }
        return !this.records.getValue(id);
    }

    public void addIndex(ColumnType type, String name) {
        ColumnIndex column = ColumnIndex.createColumn(this, name, type);
        this.addIndex(column);
    }

    public void addIndex(ColumnIndex index) {
        this.columnIndices.add(index);
        this.columnIndexByName.put(index.getName(), index);
        this.fileFieldNames = null;
        this.textFields = null;
    }

    public Filter createFullTextFilter(String query, String ... fieldNames) {
        String[] terms;
        AndFilter andFilter = new AndFilter();
        if (query == null || query.isBlank()) {
            return andFilter;
        }
        for (String term : terms = query.split(" ")) {
            if (term.isBlank()) continue;
            boolean isNegation = term.startsWith("!");
            TextFilter textFilter = this.parseTextFilter(term);
            Filter fullTextFilter = this.createFullTextFilter(textFilter, !isNegation, fieldNames);
            andFilter.and(fullTextFilter);
        }
        return andFilter;
    }

    private TextFilter parseTextFilter(String term) {
        boolean negation = false;
        boolean similar = false;
        boolean startsWith = false;
        boolean equals = false;
        if (term.startsWith("!")) {
            negation = true;
            term = term.substring(1);
        }
        if (term.endsWith("+")) {
            similar = true;
            term = term.substring(0, term.length() - 1);
        }
        if (term.endsWith("*")) {
            startsWith = true;
            term = term.substring(0, term.length() - 1);
        }
        if (term.contains("\"")) {
            equals = true;
            term = term.replace("\"", "");
        }
        if (equals) {
            return negation ? TextFilter.termEqualsFilter(term) : TextFilter.termNotEqualsFilter(term);
        }
        if (similar) {
            return negation ? TextFilter.termNotSimilarFilter(term) : TextFilter.termSimilarFilter(term);
        }
        if (startsWith) {
            return negation ? TextFilter.termStartsNotWithFilter(term) : TextFilter.termStartsWithFilter(term);
        }
        return negation ? TextFilter.termContainsNotFilter(term) : TextFilter.termContainsFilter(term);
    }

    public Filter createFullTextFilter(TextFilter textFilter, String ... fieldNames) {
        return this.createFullTextFilter(textFilter, true, fieldNames);
    }

    public Filter createFullTextFilter(TextFilter textFilter, boolean orQuery, String ... fieldNames) {
        Filter filter;
        Filter filter2 = filter = orQuery ? new OrFilter() : new AndFilter();
        if (fieldNames == null || fieldNames.length == 0) {
            this.columnIndices.stream().filter(columnIndex -> columnIndex.getType() == IndexType.TEXT || columnIndex.getType() == IndexType.TRANSLATABLE_TEXT).forEach(columnIndex -> {
                IndexFilter indexFilter = new IndexFilter(columnIndex, textFilter);
                if (orQuery) {
                    filter.or(indexFilter);
                } else {
                    filter.and(indexFilter);
                }
            });
        } else {
            for (String fieldName : fieldNames) {
                ColumnIndex columnIndex2 = this.columnIndexByName.get(fieldName);
                if ((columnIndex2 == null || columnIndex2.getType() != IndexType.TEXT) && columnIndex2.getType() != IndexType.TRANSLATABLE_TEXT) continue;
                IndexFilter indexFilter = new IndexFilter(columnIndex2, textFilter);
                if (orQuery) {
                    filter.or(indexFilter);
                    continue;
                }
                filter.and(indexFilter);
            }
        }
        return filter;
    }

    public List<SortEntry> sortRecords(String columnName, BitSet records, boolean ascending, UserContext userContext, SingleReferenceIndex ... path) {
        ColumnIndex column = null;
        column = path != null && path.length > 0 ? path[path.length - 1].getReferencedTable().getColumnIndex(columnName) : this.getColumnIndex(columnName);
        if (column == null) {
            return null;
        }
        List<SortEntry> sortEntries = SortEntry.createSortEntries(records, path);
        return column.sortRecords(sortEntries, ascending, userContext);
    }

    public int createRecord(int recordId) {
        int id = 0;
        if (recordId == 0) {
            id = this.keepDeletedRecords ? Math.max(this.records.getNextId(), this.deletedRecords.getNextId()) : this.records.getNextId();
        } else {
            id = recordId;
            if (this.keepDeletedRecords && this.deletedRecords.getValue(recordId)) {
                this.deletedRecords.setValue(recordId, false);
            }
        }
        this.records.setValue(id, true);
        return id;
    }

    public void updateFullTextIndex(int id, List<FullTextIndexValue> values, boolean update) {
        if (update) {
            Set textFieldNames = values.stream().map(FullTextIndexValue::getFieldName).collect(Collectors.toSet());
            ArrayList<FullTextIndexValue> recordFullTextIndexValues = new ArrayList<FullTextIndexValue>(values);
            for (TextIndex textField : this.getTextFields()) {
                if (textFieldNames.contains(textField.getName())) continue;
                recordFullTextIndexValues.add(new FullTextIndexValue(textField.getName(), textField.getValue(id)));
            }
            for (TranslatableTextIndex translatableTextIndex : this.getTranslatedTextFields()) {
                TranslatableText translatableTextValue;
                if (textFieldNames.contains(translatableTextIndex.getName()) || (translatableTextValue = translatableTextIndex.getValue(id)) == null) continue;
                recordFullTextIndexValues.add(new FullTextIndexValue(translatableTextIndex.getName(), translatableTextValue));
            }
            this.collectionTextSearchIndex.setRecordValues(id, recordFullTextIndexValues, true);
        } else {
            this.collectionTextSearchIndex.setRecordValues(id, values, false);
        }
    }

    private List<Integer> getReferencedRecords(int id, ColumnIndex<?, ?> referenceColumn) {
        if (referenceColumn.getColumnType() == ColumnType.MULTI_REFERENCE) {
            MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)referenceColumn;
            return multiReferenceIndex.getReferencesAsList(id);
        }
        SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)referenceColumn;
        int reference = singleReferenceIndex.getValue(id);
        return reference > 0 ? Collections.singletonList(reference) : Collections.emptyList();
    }

    public void deleteRecord(int id) {
        this.deleteRecord(id, null);
    }

    private void deleteRecord(int id, ColumnIndex<?, ?> cascadeOriginIndex) {
        this.records.setValue(id, false);
        if (this.keepDeletedRecords) {
            if (this.deletedRecords.getValue(id)) {
                return;
            }
            this.deletedRecords.setValue(id, true);
        }
        for (ColumnIndex referenceColumn : this.getReferenceColumns()) {
            boolean isMultiBackReference;
            if (referenceColumn == cascadeOriginIndex) continue;
            ReferenceIndex referenceIndex = (ReferenceIndex)((Object)referenceColumn);
            boolean isCascadeDelete = referenceIndex.isCascadeDeleteReferences();
            TableIndex referencedTable = referenceIndex.getReferencedTable();
            boolean isReferenceKeepDeletedRecords = referencedTable.isKeepDeletedRecords();
            boolean isMultiReference = referenceIndex.isMultiReference();
            ColumnIndex backReferenceColumn = referenceColumn.getReferencedColumn();
            boolean isWithBackReferenceColumn = backReferenceColumn != null;
            boolean bl = isMultiBackReference = backReferenceColumn != null && backReferenceColumn.getColumnType() == ColumnType.MULTI_REFERENCE;
            List<Integer> referencedRecords = this.getReferencedRecords(id, referenceColumn);
            if (referencedRecords.isEmpty()) continue;
            if (this.keepDeletedRecords) {
                if (isReferenceKeepDeletedRecords) {
                    if (isCascadeDelete) {
                        referencedRecords.forEach(refId -> referencedTable.deleteRecord((int)refId, backReferenceColumn));
                        continue;
                    }
                    if (!isWithBackReferenceColumn) continue;
                    this.removeBackReferences(id, backReferenceColumn, isMultiBackReference, referencedRecords);
                    continue;
                }
                if (isCascadeDelete) {
                    if (isMultiReference) {
                        MultiReferenceIndex multiReferenceColumn = (MultiReferenceIndex)referenceColumn;
                        multiReferenceColumn.removeAllReferences(id, false);
                    } else {
                        SingleReferenceIndex singleReferenceColumn = (SingleReferenceIndex)referenceColumn;
                        singleReferenceColumn.setValue(id, 0, false);
                    }
                    referencedRecords.forEach(referencedTable::deleteRecord);
                    continue;
                }
                if (!isWithBackReferenceColumn) continue;
                this.removeBackReferences(id, backReferenceColumn, isMultiBackReference, referencedRecords);
                continue;
            }
            if (!isCascadeDelete) continue;
            referencedRecords.forEach(referencedTable::deleteRecord);
        }
        if (!this.keepDeletedRecords) {
            for (ColumnIndex columnIndex : this.columnIndices) {
                columnIndex.removeValue(id);
            }
            if (this.collectionTextSearchIndex != null) {
                this.collectionTextSearchIndex.delete(id, this.getFileFieldNames());
            }
        }
    }

    private void removeBackReferences(int id, ColumnIndex<?, ?> backReferenceColumn, boolean isMultiBackReference, List<Integer> referencedRecords) {
        if (isMultiBackReference) {
            MultiReferenceIndex multiBackReferenceColumn = (MultiReferenceIndex)backReferenceColumn;
            referencedRecords.forEach(refId -> multiBackReferenceColumn.removeReferences((int)refId, Collections.singletonList(id), true));
        } else {
            SingleReferenceIndex singleBackReferenceColumn = (SingleReferenceIndex)backReferenceColumn;
            referencedRecords.forEach(refId -> {
                int value = singleBackReferenceColumn.getValue((int)refId);
                if (id == value) {
                    singleBackReferenceColumn.setValue((int)refId, 0, true);
                }
            });
        }
    }

    public void restoreRecord(int id) {
        this.restoreRecord(id, null);
    }

    public void restoreRecord(int id, ColumnIndex<?, ?> cascadeOriginIndex) {
        if (!this.keepDeletedRecords || !this.deletedRecords.getValue(id)) {
            return;
        }
        this.deletedRecords.setValue(id, false);
        for (ColumnIndex referenceColumn : this.getReferenceColumns()) {
            boolean isMultiBackReference;
            if (referenceColumn == cascadeOriginIndex) continue;
            ReferenceIndex referenceIndex = (ReferenceIndex)((Object)referenceColumn);
            boolean isCascadeDelete = referenceIndex.isCascadeDeleteReferences();
            TableIndex referencedTable = referenceIndex.getReferencedTable();
            boolean isReferenceKeepDeletedRecords = referencedTable.isKeepDeletedRecords();
            boolean isMultiReference = referenceIndex.isMultiReference();
            ColumnIndex backReferenceColumn = referenceColumn.getReferencedColumn();
            boolean isWithBackReferenceColumn = backReferenceColumn != null;
            boolean bl = isMultiBackReference = backReferenceColumn != null && backReferenceColumn.getColumnType() == ColumnType.MULTI_REFERENCE;
            List<Integer> referencedRecords = this.getReferencedRecords(id, referenceColumn);
            if (referencedRecords.isEmpty()) continue;
            if (isReferenceKeepDeletedRecords) {
                if (isCascadeDelete) {
                    referencedRecords.forEach(refId -> referencedTable.restoreRecord((int)refId, backReferenceColumn));
                    continue;
                }
                if (!isWithBackReferenceColumn) continue;
                this.restoreBackReferences(id, referenceColumn, referencedTable, isMultiReference, backReferenceColumn, isMultiBackReference, referencedRecords);
                continue;
            }
            if (isCascadeDelete || !isWithBackReferenceColumn) continue;
            this.restoreBackReferences(id, referenceColumn, referencedTable, isMultiReference, backReferenceColumn, isMultiBackReference, referencedRecords);
        }
        this.records.setValue(id, true);
    }

    private void restoreBackReferences(int id, ColumnIndex<?, ?> referenceColumn, TableIndex referencedTable, boolean isMultiReference, ColumnIndex<?, ?> backReferenceColumn, boolean isMultiBackReference, List<Integer> referencedRecords) {
        if (isMultiBackReference) {
            MultiReferenceIndex multiBackReferenceColumn = (MultiReferenceIndex)backReferenceColumn;
            referencedRecords.forEach(refId -> {
                if (referencedTable.isStored((int)refId)) {
                    multiBackReferenceColumn.addReferences((int)refId, Collections.singletonList(id), true);
                } else if (isMultiReference) {
                    MultiReferenceIndex multiReferenceColumn = (MultiReferenceIndex)referenceColumn;
                    multiReferenceColumn.removeAllReferences(id, true);
                } else {
                    SingleReferenceIndex singleReferenceColumn = (SingleReferenceIndex)referenceColumn;
                    singleReferenceColumn.setValue(id, 0, true);
                }
            });
        } else {
            SingleReferenceIndex singleBackReferenceColumn = (SingleReferenceIndex)backReferenceColumn;
            referencedRecords.forEach(refId -> {
                if (referencedTable.isStored((int)refId)) {
                    int value = singleBackReferenceColumn.getValue((int)refId);
                    if (value == 0) {
                        singleBackReferenceColumn.setValue((int)refId, id, true);
                    } else if (isMultiReference) {
                        MultiReferenceIndex multiReferenceColumn = (MultiReferenceIndex)referenceColumn;
                        multiReferenceColumn.removeAllReferences(id, true);
                    } else {
                        SingleReferenceIndex singleReferenceColumn = (SingleReferenceIndex)referenceColumn;
                        singleReferenceColumn.setValue(id, 0, true);
                    }
                }
            });
        }
    }

    public void setTransactionId(int id, long transactionId) {
        if (!this.tableConfig.isCheckpoints()) {
            return;
        }
        if (this.transactionIndex == null) {
            this.transactionIndex = this.getTransactionIndex();
        }
        this.transactionIndex.setValue(id, transactionId);
    }

    public long getTransactionId(int id) {
        if (id == 0 || !this.tableConfig.isCheckpoints()) {
            return 0L;
        }
        if (this.transactionIndex == null) {
            this.transactionIndex = this.getTransactionIndex();
        }
        return this.transactionIndex.getValue(id);
    }

    private LongIndex getTransactionIndex() {
        if (!this.tableConfig.isCheckpoints()) {
            return null;
        }
        return (LongIndex)this.getColumnIndex("metaLastTransactionId");
    }

    private List<String> getFileFieldNames() {
        if (this.fileFieldNames == null) {
            this.fileFieldNames = this.columnIndices.stream().filter(index -> index.getType() == IndexType.FILE).map(ColumnIndex::getName).collect(Collectors.toList());
        }
        return this.fileFieldNames;
    }

    private List<TextIndex> getTextFields() {
        if (this.textFields == null) {
            this.textFields = this.columnIndices.stream().filter(index -> index.getType() == IndexType.TEXT).map(index -> (TextIndex)index).collect(Collectors.toList());
        }
        return this.textFields;
    }

    private List<TranslatableTextIndex> getTranslatedTextFields() {
        if (this.translatedTextFields == null) {
            this.translatedTextFields = this.columnIndices.stream().filter(index -> index.getType() == IndexType.TRANSLATABLE_TEXT).map(index -> (TranslatableTextIndex)index).collect(Collectors.toList());
        }
        return this.translatedTextFields;
    }

    public BitSet getRecordBitSet() {
        return this.records.getBitSet();
    }

    public BitSet getDeletedRecordsBitSet() {
        if (!this.keepDeletedRecords) {
            return null;
        }
        return this.deletedRecords.getBitSet();
    }

    public List<ColumnIndex> getColumnIndices() {
        return this.columnIndices;
    }

    public List<ColumnIndex> getReferenceColumns() {
        return this.columnIndices.stream().filter(column -> column.getColumnType().isReference()).collect(Collectors.toList());
    }

    public ColumnIndex getColumnIndex(String name) {
        return this.columnIndexByName.get(name);
    }

    public boolean isKeepDeletedRecords() {
        return this.keepDeletedRecords;
    }

    @Override
    public int getMappingId() {
        return this.mappingId;
    }

    @Override
    public void setMappingId(int id) {
        if (this.mappingId > 0 && this.mappingId != id) {
            throw new RuntimeException("Error mapping index with different id:" + this.mappingId + " -> " + id);
        }
        if (this.mappingId > 0) {
            return;
        }
        this.mappingId = id;
        this.indexMetaData.setMappingId(id);
    }

    public void merge(Table table) {
        for (Column column : table.getColumns()) {
            ColumnIndex localColumn = this.getColumnIndex(column.getName());
            if (localColumn == null) {
                localColumn = ColumnIndex.createColumn(this, column.getName(), column.getType());
                this.addIndex(localColumn);
            }
            if (localColumn.getMappingId() != 0) continue;
            localColumn.setMappingId(column.getMappingId());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("collection: ").append(this.name).append(", id:").append(this.mappingId).append("\n");
        for (ColumnIndex column : this.columnIndices) {
            sb.append("\t").append(column.toString()).append("\n");
        }
        return sb.toString();
    }

    public void close() {
        try {
            logger.info("Shutdown on collection:" + this.name);
            if (this.collectionTextSearchIndex != null) {
                this.collectionTextSearchIndex.commit(true);
            }
            this.records.setValue(0, true);
            this.records.close();
            for (ColumnIndex column : this.columnIndices) {
                column.close();
            }
            this.recordVersioningIndex.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        this.collectionTextSearchIndex.drop();
        for (ColumnIndex column : this.columnIndices) {
            column.drop();
        }
    }

    @Override
    public String getFQN() {
        return this.parentFQN + "." + this.name;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseIndex getDatabaseIndex() {
        return this.databaseIndex;
    }
}

