/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.single;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.buffer.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.reference.CyclicReferenceUpdate;
import org.teamapps.universaldb.index.reference.ReferenceIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.value.RecordReference;

public class SingleReferenceIndex
extends AbstractIndex<RecordReference, NumericFilter>
implements ReferenceIndex {
    private final PrimitiveEntryAtomicStore atomicStore;
    private TableIndex referencedTable;
    private boolean cyclicReferences;
    private boolean cascadeDeleteReferences;
    private SingleReferenceIndex reverseSingleIndex;
    private MultiReferenceIndex reverseMultiIndex;

    public SingleReferenceIndex(String name, TableIndex tableIndex, ColumnType columnType) {
        super(name, tableIndex, columnType, FullTextIndexingOptions.NOT_INDEXED);
        this.atomicStore = new PrimitiveEntryAtomicStore(tableIndex.getDataPath(), name);
    }

    public void setReferencedTable(TableIndex referencedTable, ColumnIndex reverseIndex, boolean cascadeDeleteReferences) {
        this.referencedTable = referencedTable;
        if (reverseIndex != null) {
            if (reverseIndex instanceof SingleReferenceIndex) {
                this.reverseSingleIndex = (SingleReferenceIndex)reverseIndex;
            } else {
                this.reverseMultiIndex = (MultiReferenceIndex)reverseIndex;
            }
            this.cyclicReferences = true;
        }
        this.cascadeDeleteReferences = cascadeDeleteReferences;
    }

    @Override
    public IndexType getType() {
        return IndexType.REFERENCE;
    }

    @Override
    public TableIndex getReferencedTable() {
        return this.referencedTable;
    }

    @Override
    public boolean isCascadeDeleteReferences() {
        return this.cascadeDeleteReferences;
    }

    @Override
    public boolean isMultiReference() {
        return false;
    }

    @Override
    public ColumnIndex getReferencedColumn() {
        if (this.reverseSingleIndex != null) {
            return this.reverseSingleIndex;
        }
        return this.reverseMultiIndex;
    }

    @Override
    public RecordReference getGenericValue(int id) {
        int value = this.getValue(id);
        if (value == 0) {
            return null;
        }
        return new RecordReference(value, 0);
    }

    @Override
    public boolean isEmpty(int id) {
        return this.getValue(id) == 0;
    }

    @Override
    public void setGenericValue(int id, RecordReference value) {
        if (value == null) {
            this.setValue(id, 0);
        } else {
            this.setValue(id, value.getRecordId());
        }
    }

    public List<CyclicReferenceUpdate> setReferenceValue(int id, RecordReference value) {
        int referencedId = value != null ? value.getRecordId() : 0;
        return this.setValue(id, referencedId);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, 0);
    }

    public int getValue(int id) {
        return this.atomicStore.getInt(id);
    }

    public List<CyclicReferenceUpdate> setValue(int id, int value) {
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (this.cyclicReferences) {
            this.setCyclicReferences(id, value, cyclicReferenceUpdates);
        }
        this.setIndexValue(id, value);
        return cyclicReferenceUpdates;
    }

    public List<CyclicReferenceUpdate> setValue(int id, int value, boolean cyclic) {
        ArrayList<CyclicReferenceUpdate> cyclicReferenceUpdates = new ArrayList<CyclicReferenceUpdate>();
        if (this.cyclicReferences && !cyclic) {
            this.setCyclicReferences(id, value, cyclicReferenceUpdates);
        }
        this.setIndexValue(id, value);
        return cyclicReferenceUpdates;
    }

    private void setCyclicReferences(int id, int value, List<CyclicReferenceUpdate> cyclicReferenceUpdates) {
        int previousValue = this.getValue(id);
        if (previousValue != value) {
            if (this.reverseSingleIndex != null) {
                if (previousValue > 0) {
                    int orphanedReference = this.reverseSingleIndex.getValue(previousValue);
                    assert (orphanedReference > 0);
                    this.setIndexValue(orphanedReference, 0);
                    this.reverseSingleIndex.setIndexValue(previousValue, 0);
                    cyclicReferenceUpdates.add(new CyclicReferenceUpdate(this.reverseSingleIndex, true, previousValue, 0));
                }
                if (value > 0) {
                    this.reverseSingleIndex.setIndexValue(value, id);
                    cyclicReferenceUpdates.add(new CyclicReferenceUpdate(this.reverseSingleIndex, false, value, id));
                }
            } else {
                if (previousValue > 0) {
                    this.reverseMultiIndex.removeReferences(previousValue, Collections.singletonList(id), true);
                    cyclicReferenceUpdates.add(new CyclicReferenceUpdate(this.reverseMultiIndex, true, previousValue, id));
                }
                if (value > 0) {
                    this.reverseMultiIndex.addReferences(value, Collections.singletonList(id), true);
                    cyclicReferenceUpdates.add(new CyclicReferenceUpdate(this.reverseMultiIndex, false, value, id));
                }
            }
        }
    }

    public void setIndexValue(int id, int value) {
        this.atomicStore.setInt(id, value);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            int value1 = this.getValue(o1.getLeafId());
            int value2 = this.getValue(o2.getLeafId());
            return Integer.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeInt(value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            int value = dataInputStream.readInt();
            this.setIndexValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.atomicStore.close();
    }

    @Override
    public void drop() {
        this.atomicStore.drop();
    }

    @Override
    public BitSet filter(BitSet records, NumericFilter numericFilter) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (numericFilter.getValues() != null) {
            for (Number value : numericFilter.getValues()) {
                set.add(value.intValue());
            }
        }
        switch (numericFilter.getFilterType()) {
            case EQUALS: {
                return this.filterEquals(records, numericFilter.getValue1().intValue());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, numericFilter.getValue1().intValue());
            }
            case GREATER: {
                return this.filterGreater(records, numericFilter.getValue1().intValue());
            }
            case GREATER_EQUALS: {
                return this.filterGreaterOrEquals(records, numericFilter.getValue1().intValue());
            }
            case SMALLER: {
                return this.filterSmaller(records, numericFilter.getValue1().intValue());
            }
            case SMALLER_EQUALS: {
                return this.filterSmallerOrEquals(records, numericFilter.getValue1().intValue());
            }
            case BETWEEN: {
                return this.filterBetween(records, numericFilter.getValue1().intValue(), numericFilter.getValue2().intValue());
            }
            case BETWEEN_EXCLUSIVE: {
                return this.filterBetweenExclusive(records, numericFilter.getValue1().intValue(), numericFilter.getValue2().intValue());
            }
            case CONTAINS: {
                return this.filterContains(records, set);
            }
            case CONTAINS_NOT: {
                return this.filterContainsNot(records, set);
            }
        }
        return null;
    }

    public BitSet filterEquals(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreater(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value > compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreaterOrEquals(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value >= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmaller(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value < compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmallerOrEquals(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value <= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetween(BitSet bitSet, int start, int end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value >= start && value <= end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetweenExclusive(BitSet bitSet, int start, int end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value > start && value < end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContains(BitSet bitSet, Set<Integer> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsNot(BitSet bitSet, Set<Integer> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (!set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

