/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.Schema;

public class Table
implements MappedObject {
    public static final String FIELD_CHECKPOINTS = "metaLastTransactionId";
    public static final String FIELD_VERSIONING = "metaLastTransactionPosition";
    public static final String FIELD_HIERARCHY = "metaHierarchy";
    public static final String FIELD_CREATION_DATE = "metaCreationDate";
    public static final String FIELD_CREATED_BY = "metaCreatedBy";
    public static final String FIELD_MODIFICATION_DATE = "metaModificationDate";
    public static final String FIELD_MODIFIED_BY = "metaModifiedBy";
    public static final String FIELD_DELETION_DATE = "metaDeletionDate";
    public static final String FIELD_DELETED_BY = "metaDeletedBy";
    public static final String FIELD_RESTORE_DATE = "metaRestoreDate";
    public static final String FIELD_RESTORED_BY = "metaRestoredBy";
    public static final String[] FORBIDDEN_COLUMN_NAMES = new String[]{"metaLastTransactionId", "metaLastTransactionPosition", "metaHierarchy", "metaCreationDate", "metaCreatedBy", "metaModificationDate", "metaModifiedBy", "metaDeletionDate", "metaDeletedBy", "metaRestoreDate", "metaRestoredBy", "coll-recs", "coll-del-recs", "versioning-pos"};
    private final Database database;
    private final String name;
    private final TableConfig tableConfig;
    private final boolean view;
    private final String referencedTablePath;
    private final List<Column> columns = new ArrayList<Column>();
    private int mappingId;

    public static boolean isReservedMetaName(String name) {
        for (String columnName : FORBIDDEN_COLUMN_NAMES) {
            if (!name.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public Table(Database database, String name, TableConfig tableConfig) {
        this(database, name, tableConfig, false, null);
    }

    public Table(Database database, String name, TableConfig tableConfig, boolean view, String referencedTablePath) {
        this.database = database;
        this.name = name;
        this.tableConfig = tableConfig;
        this.view = view;
        this.referencedTablePath = referencedTablePath;
        if (tableConfig.isCheckpoints()) {
            this.addLong(FIELD_CHECKPOINTS);
        }
        if (tableConfig.isVersioning()) {
            this.addLong(FIELD_VERSIONING);
        }
        if (tableConfig.isHierarchy()) {
            this.addInteger(FIELD_HIERARCHY);
        }
        if (tableConfig.trackCreation()) {
            this.addTimestamp(FIELD_CREATION_DATE);
            this.addInteger(FIELD_CREATED_BY);
        }
        if (tableConfig.trackModification()) {
            this.addTimestamp(FIELD_MODIFICATION_DATE);
            this.addInteger(FIELD_MODIFIED_BY);
        }
        if (tableConfig.keepDeleted()) {
            this.addTimestamp(FIELD_DELETION_DATE);
            this.addInteger(FIELD_DELETED_BY);
            this.addTimestamp(FIELD_RESTORE_DATE);
            this.addInteger(FIELD_RESTORED_BY);
        }
    }

    public Table addBoolean(String name) {
        this.addColumn(name, ColumnType.BOOLEAN);
        return this;
    }

    public Table addShort(String name) {
        this.addColumn(name, ColumnType.SHORT);
        return this;
    }

    public Table addInteger(String name) {
        this.addColumn(name, ColumnType.INT);
        return this;
    }

    public Table addLong(String name) {
        this.addColumn(name, ColumnType.LONG);
        return this;
    }

    public Table addFloat(String name) {
        this.addColumn(name, ColumnType.FLOAT);
        return this;
    }

    public Table addDouble(String name) {
        this.addColumn(name, ColumnType.DOUBLE);
        return this;
    }

    public Table addText(String name) {
        this.addColumn(name, ColumnType.TEXT);
        return this;
    }

    public Table addTranslatableText(String name) {
        this.addColumn(name, ColumnType.TRANSLATABLE_TEXT);
        return this;
    }

    public Table addFile(String name) {
        this.addColumn(name, ColumnType.FILE);
        return this;
    }

    public Table addBinary(String name) {
        this.addColumn(name, ColumnType.BINARY);
        return this;
    }

    public Table addTimestamp(String name) {
        this.addColumn(name, ColumnType.TIMESTAMP);
        return this;
    }

    public Table addDate(String name) {
        this.addColumn(name, ColumnType.DATE);
        return this;
    }

    public Table addTime(String name) {
        this.addColumn(name, ColumnType.TIME);
        return this;
    }

    public Table addDateTime(String name) {
        this.addColumn(name, ColumnType.DATE_TIME);
        return this;
    }

    public Table addLocalDate(String name) {
        this.addColumn(name, ColumnType.LOCAL_DATE);
        return this;
    }

    public Table addReference(String name, Table referencedTable, boolean multiReference) {
        return this.addReference(name, referencedTable, multiReference, null, false);
    }

    public Table addReference(String name, Table referencedTable, boolean multiReference, boolean cascadeDeleteReferences) {
        return this.addReference(name, referencedTable, multiReference, null, cascadeDeleteReferences);
    }

    public Table addReference(String name, Table referencedTable, boolean multiReference, String backReference) {
        return this.addReference(name, referencedTable, multiReference, backReference, false);
    }

    public Table addReference(String name, Table referencedTable, boolean multiReference, String backReference, boolean cascadeDeleteReferences) {
        Column column = this.addColumn(name, multiReference ? ColumnType.MULTI_REFERENCE : ColumnType.SINGLE_REFERENCE);
        column.setReferencedTable(referencedTable);
        column.setBackReference(backReference);
        column.setCascadeDeleteReferences(cascadeDeleteReferences);
        return this;
    }

    public Table addEnum(String name, String ... values) {
        Column column = this.addColumn(name, ColumnType.ENUM);
        column.setEnumValues(Arrays.asList(values));
        return this;
    }

    public Column addColumn(String name, ColumnType columnType) {
        Schema.checkName(name);
        Column column = new Column(this, name, columnType);
        this.columns.add(column);
        return column;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getName() {
        return this.name;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public boolean isView() {
        return this.view;
    }

    public String getReferencedTablePath() {
        return this.referencedTablePath;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Column addColumn(Column column) {
        this.columns.add(column);
        return column;
    }

    public Column getColumn(String name) {
        return this.columns.stream().filter(column -> column.getName().equals(name)).findAny().orElse(null);
    }

    @Override
    public String getFQN() {
        return this.getDatabase().getFQN() + "." + this.name;
    }

    @Override
    public int getMappingId() {
        return this.mappingId;
    }

    @Override
    public void setMappingId(int mappingId) {
        this.mappingId = mappingId;
    }

    public String createDefinition(boolean ignoreMapping) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t").append(this.name).append(" as ");
        if (this.view) {
            sb.append("VIEW REFERENCING ").append(this.referencedTablePath);
        } else {
            sb.append("TABLE ").append(this.tableConfig.writeConfig());
        }
        sb.append(this.database.createMappingDefinition(this.mappingId, ignoreMapping));
        sb.append("\n");
        this.columns.forEach(column -> sb.append(column.createDefinition(ignoreMapping)));
        return sb.toString();
    }

    public boolean isCompatibleWith(Table table) {
        if (this.getMappingId() > 0 && table.getMappingId() > 0 && this.getMappingId() != table.getMappingId()) {
            return false;
        }
        for (Column column : table.getColumns()) {
            Column localColumn = this.getColumn(column.getName());
            if (localColumn != null) {
                if (localColumn.getType() != column.getType()) {
                    return false;
                }
                if (localColumn.getMappingId() <= 0 || column.getMappingId() <= 0 || localColumn.getMappingId() == column.getMappingId()) continue;
                return false;
            }
            if (column.getMappingId() == 0 || !this.getDatabase().getSchema().getMappingIds().contains(column.getMappingId())) continue;
            return false;
        }
        return true;
    }

    public void merge(Table table) {
        this.tableConfig.merge(table.getTableConfig());
        for (Column column : table.getColumns()) {
            Column localColumn = this.getColumn(column.getName());
            if (localColumn == null) {
                this.addColumn(column);
                continue;
            }
            if (localColumn.getMappingId() != 0) continue;
            localColumn.setMappingId(column.getMappingId());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("collection: ").append(this.name).append(", id:").append(this.mappingId).append("\n");
        for (Column column : this.columns) {
            sb.append("\t").append(column.toString()).append("\n");
        }
        return sb.toString();
    }
}

