/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.universaldb.util.DataStreamUtil;

public class FileFullTextContentEntry {
    private final int recordId;
    private final int version;
    private final int length;
    private final String contentText;

    public FileFullTextContentEntry(int recordId, int version, int length, String contentText) {
        this.recordId = recordId;
        this.version = version;
        this.length = length;
        this.contentText = contentText;
    }

    public FileFullTextContentEntry(DataInputStream dataInputStream) throws IOException {
        this.recordId = dataInputStream.readInt();
        this.version = dataInputStream.readInt();
        this.length = dataInputStream.readInt();
        this.contentText = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
    }

    public byte[] getIndexValue() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(this.recordId);
        dos.writeInt(this.version);
        dos.writeInt(this.length);
        DataStreamUtil.writeStringWithLengthHeader(dos, this.contentText);
        return bos.toByteArray();
    }

    public int getRecordId() {
        return this.recordId;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public String getContentText() {
        return this.contentText;
    }
}

