/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.reference.value.MultiReferenceValue;
import org.teamapps.universaldb.index.reference.value.MultiReferenceValueType;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.reference.value.ResolvedMultiReferenceUpdate;

public class MultiReferenceEditValue
implements MultiReferenceValue {
    private boolean removeAll;
    private final List<RecordReference> addReferences = new ArrayList<RecordReference>();
    private final List<RecordReference> removeReferences = new ArrayList<RecordReference>();
    private final List<RecordReference> setReferences = new ArrayList<RecordReference>();

    public MultiReferenceEditValue() {
    }

    public MultiReferenceEditValue(DataInputStream dis) throws IOException {
        this.removeAll = dis.readBoolean();
        this.addReferences.addAll(this.readReferences(dis));
        this.removeReferences.addAll(this.readReferences(dis));
        this.setReferences.addAll(this.readReferences(dis));
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeBoolean(this.removeAll);
        this.writeReferences(this.addReferences, dos);
        this.writeReferences(this.removeReferences, dos);
        this.writeReferences(this.setReferences, dos);
    }

    public void updateReferences(Map<Integer, Integer> recordIdByCorrelationId) {
        this.addReferences.stream().filter(ref -> ref.getRecordId() == 0).forEach(ref -> ref.setRecordId((Integer)recordIdByCorrelationId.get(ref.getCorrelationId())));
        this.removeReferences.stream().filter(ref -> ref.getRecordId() == 0).forEach(ref -> ref.setRecordId((Integer)recordIdByCorrelationId.get(ref.getCorrelationId())));
        this.setReferences.stream().filter(ref -> ref.getRecordId() == 0).forEach(ref -> ref.setRecordId((Integer)recordIdByCorrelationId.get(ref.getCorrelationId())));
    }

    public ResolvedMultiReferenceUpdate getResolvedUpdateValue() {
        if (this.removeAll) {
            return ResolvedMultiReferenceUpdate.createRemoveAllReferences();
        }
        if (!this.setReferences.isEmpty()) {
            return ResolvedMultiReferenceUpdate.createSetReferences(this.setReferences.stream().map(RecordReference::getRecordId).filter(id -> id != 0).collect(Collectors.toList()));
        }
        List<Integer> addRecords = this.addReferences.stream().map(RecordReference::getRecordId).filter(id -> id != 0).collect(Collectors.toList());
        List<Integer> removeRecords = this.removeReferences.stream().map(RecordReference::getRecordId).filter(id -> id != 0).collect(Collectors.toList());
        return ResolvedMultiReferenceUpdate.createAddRemoveReferences(addRecords, removeRecords);
    }

    public void setRemoveAll() {
        this.removeAll = true;
        this.addReferences.clear();
        this.removeReferences.clear();
        this.setReferences.clear();
    }

    public void setReferences(List<RecordReference> references) {
        this.setReferences.clear();
        this.removeAll = false;
        this.addReferences.clear();
        this.removeReferences.clear();
        HashSet referenceSet = new HashSet();
        references.forEach(reference -> {
            if (!referenceSet.contains(reference)) {
                referenceSet.add(reference);
                this.setReferences.add((RecordReference)reference);
            }
        });
    }

    public void addReferences(List<RecordReference> references) {
        if (!this.setReferences.isEmpty()) {
            HashSet<RecordReference> referenceSet = new HashSet<RecordReference>(this.setReferences);
            references.forEach(reference -> {
                if (!referenceSet.contains(reference)) {
                    this.setReferences.add((RecordReference)reference);
                    referenceSet.add((RecordReference)reference);
                }
            });
        } else {
            HashSet<RecordReference> addSet = new HashSet<RecordReference>(this.addReferences);
            references.forEach(reference -> {
                this.removeReferences.remove(reference);
                if (!addSet.contains(reference)) {
                    this.addReferences.add((RecordReference)reference);
                }
            });
        }
    }

    public void removeReferences(List<RecordReference> references) {
        if (!this.setReferences.isEmpty()) {
            references.forEach(this.setReferences::remove);
        } else if (this.removeAll) {
            references.forEach(this.addReferences::remove);
        } else {
            references.forEach(reference -> {
                if (this.addReferences.contains(reference)) {
                    this.addReferences.remove(reference);
                } else {
                    this.removeReferences.add((RecordReference)reference);
                }
            });
        }
    }

    public boolean isRemoveAll() {
        return this.removeAll;
    }

    public List<RecordReference> getAddReferences() {
        return this.addReferences;
    }

    public List<RecordReference> getRemoveReferences() {
        return this.removeReferences;
    }

    public List<RecordReference> getSetReferences() {
        return this.setReferences;
    }

    @Override
    public MultiReferenceValueType getType() {
        return MultiReferenceValueType.EDIT_VALUE;
    }

    @Override
    public void writeValues(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.removeAll);
        this.writeReferences(this.addReferences, dataOutputStream);
        this.writeReferences(this.removeReferences, dataOutputStream);
        this.writeReferences(this.setReferences, dataOutputStream);
    }

    public void writeReferences(List<RecordReference> references, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(references.size());
        for (RecordReference reference : references) {
            dataOutputStream.writeInt(reference.getRecordId());
            dataOutputStream.writeInt(reference.getCorrelationId());
        }
    }

    @Override
    public void readValues(DataInputStream dataInputStream) throws IOException {
        this.removeAll = dataInputStream.readBoolean();
        this.addReferences.addAll(this.readReferences(dataInputStream));
        this.removeReferences.addAll(this.readReferences(dataInputStream));
        this.setReferences.addAll(this.readReferences(dataInputStream));
    }

    private List<RecordReference> readReferences(DataInputStream dataInputStream) throws IOException {
        ArrayList<RecordReference> references = new ArrayList<RecordReference>();
        int len = dataInputStream.readInt();
        for (int i = 0; i < len; ++i) {
            int recordId = dataInputStream.readInt();
            int correlationId = dataInputStream.readInt();
            references.add(new RecordReference(recordId, correlationId));
        }
        return references;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.removeAll) {
            sb.append("REMOVE ALL ENTRIES");
        }
        if (!this.removeReferences.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("REMOVE (").append(this.removeReferences.stream().map(val -> "" + val).collect(Collectors.joining(", "))).append(")");
        }
        if (!this.addReferences.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("ADD (").append(this.addReferences.stream().map(val -> "" + val).collect(Collectors.joining(", "))).append(")");
        }
        if (!this.setReferences.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("SET (").append(this.setReferences.stream().map(val -> "" + val).collect(Collectors.joining(", "))).append(")");
        }
        return sb.toString();
    }

    @Override
    public boolean isEditValue() {
        return false;
    }
}

