/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.teamapps.universaldb.index.log.RotatingLogIndex;

public class LogIterator
implements Iterator<byte[]>,
AutoCloseable {
    private final List<File> logFiles;
    private int currentFileIndex = -1;
    private DataInputStream dis;
    private byte[] nextLog;

    public LogIterator(List<File> logFiles, long startPosition, boolean rotatingLogIndex) {
        this.logFiles = logFiles;
        this.seekLogPosition(startPosition, rotatingLogIndex);
        this.readLog();
    }

    private void seekLogPosition(long startPosition, boolean rotatingLogIndex) {
        try {
            long skipBytes = startPosition;
            if (rotatingLogIndex) {
                this.currentFileIndex = RotatingLogIndex.getFileIndex(startPosition);
                int filePos = RotatingLogIndex.getFilePos(startPosition);
                if (this.currentFileIndex >= this.logFiles.size()) {
                    return;
                }
                skipBytes = filePos;
            } else {
                this.currentFileIndex = 0;
            }
            this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.logFiles.get(this.currentFileIndex)), 64000));
            if (skipBytes > 0L) {
                this.dis.skipNBytes(skipBytes);
            } else if (!rotatingLogIndex) {
                this.dis.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readLog() {
        try {
            this.nextLog = null;
            if (this.dis == null) {
                ++this.currentFileIndex;
                if (this.currentFileIndex >= this.logFiles.size()) {
                    return;
                }
                this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.logFiles.get(this.currentFileIndex)), 64000));
            }
            int size = this.dis.readInt();
            byte[] bytes = new byte[size];
            this.dis.readFully(bytes);
            this.nextLog = bytes;
        }
        catch (EOFException ignore) {
            this.closeStream();
            this.dis = null;
            this.readLog();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextLog != null) {
            return true;
        }
        this.closeStream();
        return false;
    }

    @Override
    public byte[] next() {
        byte[] bytes = this.nextLog;
        this.readLog();
        return bytes;
    }

    @Override
    public void close() throws Exception {
        if (this.dis != null) {
            this.dis.close();
        }
    }

    private void closeStream() {
        try {
            if (this.dis == null) {
                return;
            }
            this.dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

