/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.EntityChangeSet;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.universaldb.schema.Table;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionRecord;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public abstract class AbstractUdbEntity<ENTITY extends Entity>
implements Entity<ENTITY>,
EntityBuilder<ENTITY> {
    private static final Logger log = LoggerFactory.getLogger(AbstractUdbEntity.class);
    private static final AtomicInteger correlationIdGenerator = new AtomicInteger();
    private static final int MAX_CORRELATION_ID = 2000000000;
    private final TableIndex tableIndex;
    private int id;
    private boolean createEntity;
    private int correlationId;
    private EntityChangeSet entityChangeSet;
    private Transaction transaction;

    public static <ENTITY> List<ENTITY> createEntityList(EntityBuilder<ENTITY> entityBuilder, List<Integer> recordIds) {
        ArrayList<ENTITY> list = new ArrayList<ENTITY>();
        for (Integer recordId : recordIds) {
            list.add(entityBuilder.build(recordId));
        }
        return list;
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, List<ENTITY> list, String sortFieldName, boolean ascending, String ... path) {
        return AbstractUdbEntity.sort(table, list, sortFieldName, ascending, UserContext.create(), path);
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, List<ENTITY> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        SingleReferenceIndex[] referencePath = AbstractUdbEntity.getReferenceIndices(table, path);
        ColumnIndex column = AbstractUdbEntity.getSortColumn(table, sortFieldName, referencePath);
        List<SortEntry> sortEntries = SortEntry.createSortEntries(list, referencePath);
        sortEntries = column.sortRecords(sortEntries, ascending, userContext);
        return sortEntries.stream().map(SortEntry::getEntity).collect(Collectors.toList());
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, EntityBuilder<ENTITY> builder, BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return AbstractUdbEntity.sort(table, builder, recordIds, sortFieldName, ascending, null, path);
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, EntityBuilder<ENTITY> builder, BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        SingleReferenceIndex[] referencePath = AbstractUdbEntity.getReferenceIndices(table, path);
        ColumnIndex column = AbstractUdbEntity.getSortColumn(table, sortFieldName, referencePath);
        List<SortEntry> sortEntries = SortEntry.createSortEntries(recordIds, referencePath);
        sortEntries = column.sortRecords(sortEntries, ascending, userContext);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (SortEntry entry : sortEntries) {
            list.add((Entity)builder.build(entry.getId()));
        }
        return list;
    }

    private static SingleReferenceIndex[] getReferenceIndices(TableIndex table, String[] path) {
        SingleReferenceIndex[] referencePath = null;
        if (path != null && path.length > 0) {
            referencePath = new SingleReferenceIndex[path.length];
            TableIndex pathTable = table;
            for (int i = 0; i < path.length; ++i) {
                referencePath[i] = (SingleReferenceIndex)pathTable.getColumnIndex(path[i]);
                pathTable = referencePath[i].getReferencedTable();
            }
        }
        return referencePath;
    }

    private static ColumnIndex getSortColumn(TableIndex table, String sortFieldName, SingleReferenceIndex[] referencePath) {
        ColumnIndex column = referencePath != null && referencePath.length > 0 ? referencePath[referencePath.length - 1].getReferencedTable().getColumnIndex(sortFieldName) : table.getColumnIndex(sortFieldName);
        return column;
    }

    public AbstractUdbEntity(TableIndex tableIndex) {
        this.tableIndex = tableIndex;
        this.createEntity = true;
        this.createCorrelationId();
    }

    public AbstractUdbEntity(TableIndex tableIndex, int id, boolean createEntity) {
        this.tableIndex = tableIndex;
        this.id = id;
        this.createEntity = createEntity;
        if (createEntity) {
            this.createCorrelationId();
        }
    }

    private void createCorrelationId() {
        if (this.correlationId > 0) {
            return;
        }
        this.correlationId = correlationIdGenerator.incrementAndGet();
        if (this.correlationId == 2000000000) {
            correlationIdGenerator.set(0);
        }
    }

    @Override
    public int getId() {
        if (this.id == 0 && this.transaction != null) {
            this.id = this.transaction.getResolvedRecordIdByCorrelationId(this.correlationId);
        }
        return this.id;
    }

    protected int getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public Object getEntityValue(String fieldName) {
        ColumnIndex index = this.tableIndex.getColumnIndex(fieldName);
        if (index != null) {
            return index.getGenericValue(this.getId());
        }
        return null;
    }

    @Override
    public void setEntityValue(String fieldName, Object value) {
        ColumnIndex index = this.tableIndex.getColumnIndex(fieldName);
        if (index != null) {
            this.setChangeValue(index, value, null);
        }
    }

    protected void setChangeValue(ColumnIndex index, Object value, TableIndex tableIndex) {
        this.checkChangeSet();
        this.entityChangeSet.addChangeValue(index, value);
    }

    protected void setSingleReferenceValue(ColumnIndex index, Entity reference, TableIndex tableIndex) {
        AbstractUdbEntity entity = (AbstractUdbEntity)reference;
        RecordReference recordReference = null;
        if (entity != null) {
            recordReference = new RecordReference(entity.getId(), entity.getCorrelationId());
        }
        this.checkChangeSet();
        this.entityChangeSet.addChangeValue(index, recordReference);
        this.entityChangeSet.setReferenceChange(index, entity);
    }

    protected <OTHER_ENTITY extends Entity> List<OTHER_ENTITY> createEntityList(ColumnIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        TransactionRecordValue changeValue = this.getChangeValue(index);
        MultiReferenceEditValue editValue = (MultiReferenceEditValue)changeValue.getValue();
        MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)index;
        return this.createEntityList(editValue, multiReferenceIndex.getReferencesAsList(this.id), entityBuilder);
    }

    protected <OTHER_ENTITY extends Entity> List<OTHER_ENTITY> createEntityList(MultiReferenceEditValue editValue, List<Integer> referencedRecords, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        Map<RecordReference, Entity> entityByReference = this.entityChangeSet.getEntityByReference();
        ArrayList<Entity<Object>> list = new ArrayList<Entity<Object>>();
        if (!editValue.getSetReferences().isEmpty() || editValue.isRemoveAll()) {
            List<RecordReference> references = editValue.isRemoveAll() ? editValue.getAddReferences() : editValue.getSetReferences();
            references.forEach(reference -> {
                Entity entity = (Entity)entityByReference.get(reference);
                if (entity == null && reference.getRecordId() > 0) {
                    entity = (Entity)entityBuilder.build(reference.getRecordId());
                }
                if (entity != null) {
                    list.add(entity);
                } else {
                    log.error("Cannot add reference to list: no record id and no matching correlation id!");
                }
            });
            return list;
        }
        HashSet removeSet = new HashSet();
        editValue.getRemoveReferences().forEach(reference -> {
            if (reference.getRecordId() > 0) {
                removeSet.add(reference.getRecordId());
            } else {
                Entity entity = (Entity)entityByReference.get(reference);
                if (entity != null) {
                    removeSet.add(entity.getId());
                }
            }
        });
        ArrayList addEntities = new ArrayList();
        editValue.getAddReferences().forEach(reference -> {
            Entity entity = (Entity)entityByReference.get(reference);
            if (entity == null && reference.getRecordId() > 0) {
                entity = (Entity)entityBuilder.build(reference.getRecordId());
            }
            if (entity != null) {
                addEntities.add(entity);
            }
        });
        HashSet addEntitySet = new HashSet();
        addEntities.forEach(entity -> addEntitySet.add(entity.getId()));
        for (Integer recordId : referencedRecords) {
            if (removeSet.contains(recordId) || addEntitySet.contains(recordId)) continue;
            list.add((Entity)entityBuilder.build(recordId));
        }
        list.addAll(addEntities);
        return list;
    }

    protected TransactionRecordValue getChangeValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getChangeValue(index);
    }

    protected Object getChangedValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getChangeValue(index).getValue();
    }

    protected AbstractUdbEntity getReferenceChangeValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getReferenceChange(index);
    }

    protected void addMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex);
        List<RecordReference> references = this.createRecordReferences(entities);
        editValue.addReferences(references);
    }

    protected void removeMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex);
        List<RecordReference> references = this.createRecordReferences(entities);
        editValue.removeReferences(references);
    }

    protected void setMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex) {
        if (entities == null || entities.isEmpty()) {
            this.removeAllMultiReferenceValue(multiReferenceIndex);
        } else {
            MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex);
            List<RecordReference> references = this.createRecordReferences(entities);
            editValue.setReferences(references);
        }
    }

    protected void removeAllMultiReferenceValue(MultiReferenceIndex multiReferenceIndex) {
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex);
        editValue.setRemoveAll();
    }

    private List<RecordReference> createRecordReferences(List<? extends Entity> entities) {
        ArrayList<RecordReference> references = new ArrayList<RecordReference>();
        for (Entity entity : entities) {
            AbstractUdbEntity udbEntity = (AbstractUdbEntity)entity;
            RecordReference recordReference = new RecordReference(udbEntity.getId(), udbEntity.getCorrelationId());
            references.add(recordReference);
            this.entityChangeSet.addRecordReference(recordReference, entity);
        }
        return references;
    }

    private MultiReferenceEditValue getOrCreateMultiReferenceEditValue(MultiReferenceIndex multiReferenceIndex) {
        MultiReferenceEditValue editValue;
        TransactionRecordValue changeValue = this.getChangeValue(multiReferenceIndex);
        if (changeValue != null) {
            editValue = (MultiReferenceEditValue)changeValue.getValue();
        } else {
            editValue = new MultiReferenceEditValue();
            this.setChangeValue(multiReferenceIndex, editValue, this.tableIndex);
        }
        return editValue;
    }

    public boolean getBooleanValue(BooleanIndex index) {
        if (this.isChanged(index)) {
            return (Boolean)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setBooleanValue(boolean value, BooleanIndex index) {
        if (this.getBooleanValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public short getShortValue(ShortIndex index) {
        if (this.isChanged(index)) {
            return (Short)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setShortValue(short value, ShortIndex index) {
        if (this.getShortValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public int getIntValue(IntegerIndex index) {
        if (this.isChanged(index)) {
            return (Integer)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setIntValue(int value, IntegerIndex index) {
        if (this.getIntValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public long getLongValue(LongIndex index) {
        if (this.isChanged(index)) {
            return (Long)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setLongValue(long value, LongIndex index) {
        if (this.getLongValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public float getFloatValue(FloatIndex index) {
        if (this.isChanged(index)) {
            return ((Float)this.getChangedValue(index)).floatValue();
        }
        return index.getValue(this.getId());
    }

    public void setFloatValue(float value, FloatIndex index) {
        if (this.getFloatValue(index) != value) {
            this.setChangeValue(index, Float.valueOf(value), this.tableIndex);
        }
    }

    public double getDoubleValue(DoubleIndex index) {
        if (this.isChanged(index)) {
            return (Double)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setDoubleValue(double value, DoubleIndex index) {
        if (this.getDoubleValue(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public String getTextValue(TextIndex index) {
        if (this.isChanged(index)) {
            return (String)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setTextValue(String value, TextIndex index) {
        if (!Objects.equals(this.getTextValue(index), value)) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public TranslatableText getTranslatableTextValue(TranslatableTextIndex index) {
        if (this.isChanged(index)) {
            return (TranslatableText)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setTranslatableTextValue(TranslatableText value, TranslatableTextIndex index) {
        this.setChangeValue(index, value, this.tableIndex);
    }

    public Instant getTimestampValue(IntegerIndex index) {
        int value = this.isChanged(index) ? ((Integer)this.getChangedValue(index)).intValue() : index.getValue(this.getId());
        return value == 0 ? null : Instant.ofEpochSecond(value);
    }

    public int getTimestampAsEpochSecond(IntegerIndex index) {
        if (this.isChanged(index)) {
            return (Integer)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public long getTimestampAsEpochMilli(IntegerIndex index) {
        if (this.isChanged(index)) {
            return ((Integer)this.getChangedValue(index)).longValue() * 1000L;
        }
        return (long)index.getValue(this.getId()) * 1000L;
    }

    public void setTimestampValue(Instant value, IntegerIndex index) {
        if (!Objects.equals(this.getTimestampValue(index), value)) {
            Integer intValue = value != null ? (int)value.getEpochSecond() : 0;
            this.setChangeValue(index, intValue, this.tableIndex);
        }
    }

    public void setTimestampAsEpochSecond(int value, IntegerIndex index) {
        if (this.getTimestampAsEpochSecond(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public void setTimestampAsEpochMilli(long value, IntegerIndex index) {
        if (this.getTimestampAsEpochMilli(index) != value) {
            int intValue = (int)(value / 1000L);
            this.setChangeValue(index, intValue, this.tableIndex);
        }
    }

    public Instant getTimeValue(IntegerIndex index) {
        int value = this.isChanged(index) ? ((Integer)this.getChangedValue(index)).intValue() : index.getValue(this.getId());
        return value == 0 ? null : Instant.ofEpochSecond(value);
    }

    public void setTimeValue(Instant value, IntegerIndex index) {
        if (!Objects.equals(this.getTimeValue(index), value)) {
            Integer intValue = value != null ? (int)value.getEpochSecond() : 0;
            this.setChangeValue(index, intValue, this.tableIndex);
        }
    }

    public Instant getDateValue(LongIndex index) {
        long value = this.isChanged(index) ? ((Long)this.getChangedValue(index)).longValue() : index.getValue(this.getId());
        return value == 0L ? null : Instant.ofEpochMilli(value);
    }

    public long getDateAsEpochMilli(LongIndex index) {
        if (this.isChanged(index)) {
            return (Long)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setDateValue(Instant value, LongIndex index) {
        if (!Objects.equals(this.getDateValue(index), value)) {
            Long longValue = value != null ? value.toEpochMilli() : 0L;
            this.setChangeValue(index, longValue, this.tableIndex);
        }
    }

    public void setDateAsEpochMilli(long value, LongIndex index) {
        if (this.getDateAsEpochMilli(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public Instant getDateTimeValue(LongIndex index) {
        long value = this.isChanged(index) ? ((Long)this.getChangedValue(index)).longValue() : index.getValue(this.getId());
        return value == 0L ? null : Instant.ofEpochMilli(value);
    }

    public long getDateTimeAsEpochMilli(LongIndex index) {
        if (this.isChanged(index)) {
            return (Long)this.getChangedValue(index);
        }
        return index.getValue(this.getId());
    }

    public void setDateTimeValue(Instant value, LongIndex index) {
        if (!Objects.equals(this.getDateTimeValue(index), value)) {
            Long longValue = value != null ? value.toEpochMilli() : 0L;
            this.setChangeValue(index, longValue, this.tableIndex);
        }
    }

    public void setDateTimeAsEpochMilli(long value, LongIndex index) {
        if (this.getDateTimeAsEpochMilli(index) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public LocalDate getLocalDateValue(LongIndex index) {
        long value = this.isChanged(index) ? ((Long)this.getChangedValue(index)).longValue() : index.getValue(this.getId());
        return value == 0L ? null : LocalDate.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC);
    }

    public void setLocalDateValue(LocalDate value, LongIndex index) {
        long longValue = value != null ? value.atStartOfDay(ZoneOffset.UTC).toEpochSecond() * 1000L : 0L;
        LocalDate currentValue = this.getLocalDateValue(index);
        if (!(Objects.equals(currentValue, value) || currentValue == null && longValue == 0L)) {
            this.setChangeValue(index, longValue, this.tableIndex);
        }
    }

    public void setLocalDateAsEpochMilli(long value, LongIndex index) {
        if (index.getValue(this.getId()) != value) {
            this.setChangeValue(index, value, this.tableIndex);
        }
    }

    public <ENUM extends Enum<ENUM>> ENUM getEnumValue(ShortIndex index, ENUM[] values) {
        short shortValue = this.isChanged(index) ? ((Short)this.getChangedValue(index)).shortValue() : index.getValue(this.getId());
        return shortValue == 0 ? null : (ENUM)values[shortValue - 1];
    }

    public <ENUM extends Enum<ENUM>> void setEnumValue(ShortIndex index, ENUM value) {
        short shortValue = (short)(value != null ? value.ordinal() + 1 : 0);
        if (this.getShortValue(index) != shortValue) {
            this.setChangeValue(index, shortValue, this.tableIndex);
        }
    }

    public <OTHER_ENTITY extends Entity> List<OTHER_ENTITY> getMultiReferenceValue(MultiReferenceIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        if (this.isChanged(index)) {
            return this.createEntityList(index, entityBuilder);
        }
        if (!index.isEmpty(this.getId())) {
            return AbstractUdbEntity.createEntityList(entityBuilder, index.getReferencesAsList(this.getId()));
        }
        return Collections.emptyList();
    }

    public <OTHER_ENTITY extends Entity> int getMultiReferenceValueCount(MultiReferenceIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        if (this.isChanged(index)) {
            return this.createEntityList(index, entityBuilder).size();
        }
        return index.getReferencesCount(this.getId());
    }

    public <OTHER_ENTITY extends Entity> BitSet getMultiReferenceValueAsBitSet(MultiReferenceIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        if (this.isChanged(index)) {
            BitSet bitSet = new BitSet();
            this.createEntityList(index, entityBuilder).stream().map(Entity::getId).forEach(bitSet::set);
            return bitSet;
        }
        return index.getReferencesAsBitSet(this.getId());
    }

    public boolean isChanged(ColumnIndex index) {
        return this.entityChangeSet != null && this.entityChangeSet.isChanged(index);
    }

    protected int getEntityId(Entity entity) {
        if (entity == null) {
            return 0;
        }
        return entity.getId();
    }

    protected Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void clearChanges() {
        this.entityChangeSet = null;
    }

    @Override
    public boolean isModified() {
        return this.entityChangeSet != null;
    }

    private void checkChangeSet() {
        if (this.entityChangeSet == null) {
            this.entityChangeSet = new EntityChangeSet();
            this.createCorrelationId();
        }
    }

    public void save(Transaction transaction, TableIndex tableIndex, boolean strictChangeVerification) {
        if (this.entityChangeSet != null) {
            this.transaction = transaction;
            boolean update = !this.createEntity;
            TransactionRecord transactionRecord = new TransactionRecord(tableIndex, this.id, this.correlationId, transaction.getUserId(), update, false, strictChangeVerification);
            this.entityChangeSet.setTransactionRecordValues(transaction, transactionRecord, strictChangeVerification);
            transaction.addTransactionRecord(transactionRecord);
            this.clearChanges();
            this.createEntity = false;
        }
    }

    public void save(TableIndex tableIndex) {
        this.save(tableIndex, false);
    }

    public CompletableFuture<Boolean> saveAsynchronously(TableIndex tableIndex) {
        this.save(tableIndex, true);
        return new CompletableFuture<Boolean>();
    }

    public void save(TableIndex tableIndex, boolean asynchronous) {
        if (this.entityChangeSet != null) {
            this.transaction = Transaction.create();
            this.save(this.transaction, tableIndex, false);
            this.transaction.execute(asynchronous);
            if (this.id == 0) {
                this.id = this.transaction.getResolvedRecordIdByCorrelationId(this.correlationId);
            }
        }
    }

    public TableIndex getTableIndex() {
        return this.tableIndex;
    }

    @Override
    public String getQualifiedName() {
        return this.tableIndex.getFQN();
    }

    public void delete(Transaction transaction, TableIndex tableIndex) {
        TransactionRecord transactionRecord = new TransactionRecord(tableIndex, this.id, 0, transaction.getUserId(), true);
        transaction.addTransactionRecord(transactionRecord);
        this.clearChanges();
    }

    public void delete(TableIndex tableIndex) {
        Transaction transaction = Transaction.create();
        this.delete(transaction, tableIndex);
        transaction.execute();
    }

    @Override
    public boolean isStored() {
        return this.id > 0 && this.tableIndex.isStored(this.id);
    }

    @Override
    public boolean isDeleted() {
        return this.tableIndex.isDeleted(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUdbEntity that = (AbstractUdbEntity)o;
        if (this.getId() > 0 && this.getId() == that.getId()) {
            return true;
        }
        return this.getCorrelationId() > 0 && this.getCorrelationId() == that.getCorrelationId();
    }

    public int hashCode() {
        if (this.getId() > 0) {
            return this.getId();
        }
        return this.getCorrelationId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tableIndex.getName()).append(": ").append(this.getId()).append("\n");
        ArrayList sortedFields = new ArrayList();
        sortedFields.addAll(this.tableIndex.getColumnIndices().stream().filter(column -> !Table.isReservedMetaName(column.getName())).collect(Collectors.toList()));
        sortedFields.addAll(this.tableIndex.getColumnIndices().stream().filter(column -> Table.isReservedMetaName(column.getName())).collect(Collectors.toList()));
        for (ColumnIndex column2 : sortedFields) {
            sb.append("\t").append(column2.getName()).append(": ").append(column2.getStringValue(this.getId()));
            if (this.isChanged(column2)) {
                TransactionRecordValue changeValue = this.getChangeValue(column2);
                sb.append(" -> ").append(changeValue.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

