/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.generator;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.generator.PojoCodeGenerator;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.SchemaInfoProvider;

public class ModelApiGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelApiGenerator.class);

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 2) {
            log.error("Error: missing argument(s). Mandatory arguments are: modelClassName targetPath");
            System.exit(1);
        }
        String schemaClassName = args[0];
        String targetPath = args[1];
        Class<?> schemaClass = Class.forName(schemaClassName);
        SchemaInfoProvider schemaInfoProvider = (SchemaInfoProvider)schemaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        Schema schema = schemaInfoProvider.getSchema();
        PojoCodeGenerator pojoCodeGenerator = new PojoCodeGenerator();
        File basePath = new File(targetPath);
        if (!basePath.getParentFile().exists() && basePath.getParentFile().getParentFile().exists()) {
            basePath.getParentFile().mkdir();
        }
        pojoCodeGenerator.generateCode(schema, basePath);
    }
}

