/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer;

import java.io.File;
import java.nio.charset.StandardCharsets;
import org.agrona.concurrent.AtomicBuffer;
import org.teamapps.universaldb.index.buffer.AbstractBlockEntryAtomicStore;

public class BlockEntryAtomicStore
extends AbstractBlockEntryAtomicStore {
    public BlockEntryAtomicStore(File path, String name) {
        super(path, name);
    }

    public void setBytes(int id, byte[] bytes) {
        if (id == 0) {
            return;
        }
        long lastPosition = this.getBlockPosition(id);
        if (bytes == null || bytes.length == 0) {
            this.setBlockPosition(id, 0L);
            this.removeEntry(lastPosition);
            return;
        }
        int length = bytes.length;
        Long freeSlot = this.getFreeSlot(length);
        if (freeSlot != null) {
            long position = freeSlot;
            int bufferIndex = this.getBufferIndex(position);
            int offset = this.getOffset(position, bufferIndex);
            AtomicBuffer atomicBuffer = this.getBuffer(bufferIndex);
            if (atomicBuffer.getInt(offset) != -1 * length) {
                throw new RuntimeException("Try to reuse deleted block entry that already exists, id:" + id + ", pos:" + position + ", index:" + this);
            }
            atomicBuffer.putInt(offset, length, byteOrder);
            atomicBuffer.putBytes(offset + 4, bytes);
            this.setBlockPosition(id, position);
        } else {
            long position = this.findNextBlockPosition(this.getFreeSpacePosition(), length + 4);
            this.setFreeSpacePosition(position + (long)length + 4L);
            this.ensureCapacity(position + (long)length + 4L);
            int bufferIndex = this.getBufferIndex(position);
            int offset = this.getOffset(position, bufferIndex);
            AtomicBuffer atomicBuffer = this.getBuffer(bufferIndex);
            atomicBuffer.putInt(offset, length, byteOrder);
            atomicBuffer.putBytes(offset + 4, bytes);
            this.setBlockPosition(id, position);
        }
        this.removeEntry(lastPosition);
    }

    public byte[] getBytes(int id) {
        long position = this.getBlockPosition(id);
        if (position > 0L) {
            int bufferIndex = this.getBufferIndex(position);
            int offset = this.getOffset(position, bufferIndex);
            AtomicBuffer buffer = this.getBuffer(bufferIndex);
            int len = buffer.getInt(offset);
            byte[] bytes = new byte[len];
            buffer.getBytes(offset + 4, bytes);
            return bytes;
        }
        return null;
    }

    public void removeBytes(int id) {
        if (id == 0) {
            return;
        }
        long position = this.getBlockPosition(id);
        if (position > 0L) {
            this.removeEntry(position);
            this.setBlockPosition(id, 0L);
        }
    }

    public void setText(int id, String text) {
        this.setBytes(id, text == null || text.isEmpty() ? null : text.getBytes(StandardCharsets.UTF_8));
    }

    public String getText(int id) {
        byte[] bytes = this.getBytes(id);
        return bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null;
    }

    public void removeText(int id) {
        this.removeBytes(id);
    }
}

