/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.universaldb.schema.Schema;

public class SchemaUpdate {
    private final Schema schema;
    private final long timestamp;
    private final long transactionId;

    public SchemaUpdate(Schema schema, long transactionId, long timestamp) {
        this.schema = schema;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
    }

    public SchemaUpdate(byte[] data) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        try {
            this.schema = new Schema(dis);
            this.timestamp = dis.readLong();
            this.transactionId = dis.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading log update", e);
        }
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.schema.writeSchema(dos);
        dos.writeLong(this.timestamp);
        dos.writeLong(this.transactionId);
        return bos.toByteArray();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTransactionId() {
        return this.transactionId;
    }
}

