/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.versioning;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransaction;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecord;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecordType;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecordValue;

public class RecordUpdate {
    private long previousPosition;
    private final ResolvedTransactionRecord transactionRecord;
    private final int userId;
    private final long timestamp;
    private final long transactionId;

    public static RecordUpdate createUpdate(ResolvedTransaction transaction, ResolvedTransactionRecord record) {
        return new RecordUpdate(record, transaction.getUserId(), transaction.getTimestamp(), transaction.getTransactionId());
    }

    public RecordUpdate(ResolvedTransactionRecord transactionRecord, int userId, long timestamp, long transactionId) {
        this.transactionRecord = transactionRecord;
        this.userId = userId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
    }

    public RecordUpdate(byte[] bytes) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        this.previousPosition = dis.readLong();
        this.transactionRecord = new ResolvedTransactionRecord(dis);
        this.userId = dis.readInt();
        this.timestamp = dis.readLong();
        this.transactionId = dis.readLong();
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(this.previousPosition);
        this.transactionRecord.write(dos);
        dos.writeInt(this.userId);
        dos.writeLong(this.timestamp);
        dos.writeLong(this.transactionId);
        return bos.toByteArray();
    }

    public long getPreviousPosition() {
        return this.previousPosition;
    }

    public void setPreviousPosition(long previousPosition) {
        this.previousPosition = previousPosition;
    }

    public ResolvedTransactionRecord getTransactionRecord() {
        return this.transactionRecord;
    }

    public int getUserId() {
        return this.userId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public ResolvedTransactionRecordType getRecordType() {
        return this.transactionRecord.getRecordType();
    }

    public List<ResolvedTransactionRecordValue> getRecordValues() {
        return this.transactionRecord.getRecordValues();
    }

    public ResolvedTransactionRecordValue getValue(int columnId) {
        return this.transactionRecord.getRecordValues().stream().filter(recordValue -> recordValue.getColumnId() == columnId).findFirst().orElse(null);
    }

    public int getTableId() {
        return this.transactionRecord.getTableId();
    }

    public int getRecordId() {
        return this.transactionRecord.getRecordId();
    }
}

