/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.util.BitSet;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexMetaData;
import org.teamapps.universaldb.index.TableIndex;

public abstract class AbstractIndex<TYPE, FILTER>
implements ColumnIndex<TYPE, FILTER> {
    private final File dataPath;
    private final File fullTextIndexPath;
    private final String name;
    private final TableIndex table;
    private final ColumnType columnType;
    private final FullTextIndexingOptions fullTextIndexingOptions;
    private int mappingId;
    private final IndexMetaData indexMetaData;

    public AbstractIndex(String name, TableIndex table, ColumnType columnType, FullTextIndexingOptions fullTextIndexingOptions) {
        this.name = name;
        this.dataPath = table.getDataPath();
        this.fullTextIndexPath = table.getFullTextIndexPath();
        this.table = table;
        this.columnType = columnType;
        this.fullTextIndexingOptions = fullTextIndexingOptions;
        this.indexMetaData = new IndexMetaData(this.dataPath, name, this.getFQN(), columnType.ordinal() + 1);
        this.mappingId = this.indexMetaData.getMappingId();
    }

    public File getDataPath() {
        return this.dataPath;
    }

    public File getFullTextIndexPath() {
        return this.fullTextIndexPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFQN() {
        return this.table.getFQN() + "." + this.name;
    }

    @Override
    public TableIndex getTable() {
        return this.table;
    }

    @Override
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public FullTextIndexingOptions getFullTextIndexingOptions() {
        return this.fullTextIndexingOptions;
    }

    @Override
    public int getMappingId() {
        return this.mappingId;
    }

    @Override
    public void setMappingId(int id) {
        if (this.mappingId > 0 && this.mappingId != id) {
            throw new RuntimeException("Error mapping index with different id:" + this.mappingId + " -> " + id);
        }
        if (this.mappingId > 0) {
            return;
        }
        this.mappingId = id;
        this.indexMetaData.setMappingId(id);
    }

    public String toString() {
        return "column: " + this.name + ", type:" + this.getType().name() + ", id:" + this.mappingId;
    }

    public static BitSet negateInput(BitSet records, BitSet input) {
        BitSet data = (BitSet)records.clone();
        data.andNot(input);
        return data;
    }
}

