/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicInteger;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;

public class LocalFileStore
implements FileSink,
FileProvider {
    private final File basePath;
    private AtomicInteger idGenerator;

    public LocalFileStore(File path, String name) {
        this.basePath = new File(path, name);
        this.basePath.mkdir();
        this.idGenerator = new AtomicInteger(this.basePath.listFiles().length + 1);
    }

    public String saveFile(File file) throws IOException {
        if (file == null || file.length() == 0L) {
            return null;
        }
        String fileId = "F-" + System.currentTimeMillis() + "-" + Integer.toHexString(this.idGenerator.incrementAndGet()).toUpperCase() + ".bin";
        File destFile = new File(this.basePath, fileId);
        Files.copy(file.toPath(), destFile.toPath(), new CopyOption[0]);
        return fileId;
    }

    public File getFile(String fileId) {
        return new File(this.basePath, fileId);
    }

    public String handleFile(File file) throws IOException {
        return this.saveFile(file);
    }
}

