/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.universaldb.index.buffer.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.index.buffer.RecordIndex;
import org.teamapps.universaldb.index.log.LocalFileStore;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.RotatingLogIndex;

public class MessageStore<TYPE extends MessageObject> {
    private final RecordIndex records;
    private final PrimitiveEntryAtomicStore messagePositionStore;
    private final LogIndex logIndex;
    private final LocalFileStore fileStore;
    private PojoObjectDecoder<TYPE> pojoObjectDecoder;

    public MessageStore(File path, String name, PojoObjectDecoder<TYPE> pojoObjectDecoder) {
        File basePath = new File(path, name);
        basePath.mkdir();
        this.records = new RecordIndex(basePath, "records");
        this.messagePositionStore = new PrimitiveEntryAtomicStore(basePath, "positions");
        this.logIndex = new RotatingLogIndex(basePath, "messages");
        this.fileStore = new LocalFileStore(basePath, "file-store");
        this.pojoObjectDecoder = pojoObjectDecoder;
    }

    public int getNextRecordId() {
        return this.records.createRecord();
    }

    public int addMessage(TYPE message) {
        int id = this.getNextRecordId();
        this.addMessage(id, message);
        return id;
    }

    public void addMessage(int id, TYPE message) {
        try {
            byte[] bytes = message.toBytes((FileSink)this.fileStore);
            long position = this.logIndex.writeLog(bytes);
            this.messagePositionStore.setLong(id, position);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeMessage(int id) {
        this.records.setBoolean(id, false);
        this.messagePositionStore.setLong(id, Math.abs(this.messagePositionStore.getLong(id)) * -1L);
    }

    public TYPE readMessage(int id) {
        long position = this.messagePositionStore.getLong(id);
        if (position >= 0L) {
            byte[] bytes = this.logIndex.readLog(position);
            return (TYPE)this.pojoObjectDecoder.decode(bytes, (FileProvider)this.fileStore);
        }
        return null;
    }

    public List<TYPE> readAllMessages() {
        ArrayList<TYPE> messages = new ArrayList<TYPE>();
        for (Integer id : this.records.getRecords()) {
            messages.add(this.readMessage(id));
        }
        return messages;
    }
}

