/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.teamapps.universaldb.index.text.TextFilterType;

public class SearchIndexUtil {
    public static List<String> analyze(String text, Analyzer analyzer) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            TokenStream tokenStream = analyzer.tokenStream("any", text);
            CharTermAttribute attr = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                result.add(attr.toString());
            }
            tokenStream.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Query createQuery(TextFilterType filterType, String fieldName, String value, Analyzer analyzer) {
        List<String> textParts = SearchIndexUtil.analyze(value, analyzer);
        BooleanQuery.Builder termQueries = new BooleanQuery.Builder();
        boolean containsOnlyNegationQueries = false;
        for (String textPart : textParts) {
            Term term = new Term(fieldName, textPart);
            switch (filterType) {
                case EMPTY: 
                case NOT_EMPTY: 
                case TEXT_BYTE_LENGTH_GREATER: 
                case TEXT_BYTE_LENGTH_SMALLER: {
                    return null;
                }
                case TEXT_EQUALS: 
                case TEXT_EQUALS_IGNORE_CASE: 
                case TERM_EQUALS: {
                    termQueries.add((Query)new TermQuery(term), BooleanClause.Occur.MUST);
                    break;
                }
                case TEXT_NOT_EQUALS: 
                case TERM_NOT_EQUALS: {
                    containsOnlyNegationQueries = true;
                    termQueries.add((Query)new TermQuery(term), BooleanClause.Occur.MUST_NOT);
                    break;
                }
                case TERM_STARTS_WITH: {
                    termQueries.add((Query)new PrefixQuery(term), BooleanClause.Occur.MUST);
                    break;
                }
                case TERM_STARTS_NOT_WITH: {
                    containsOnlyNegationQueries = true;
                    termQueries.add((Query)new PrefixQuery(term), BooleanClause.Occur.MUST_NOT);
                    break;
                }
                case TERM_SIMILAR: {
                    termQueries.add((Query)new FuzzyQuery(term), BooleanClause.Occur.MUST);
                    break;
                }
                case TERM_NOT_SIMILAR: {
                    containsOnlyNegationQueries = true;
                    termQueries.add((Query)new FuzzyQuery(term), BooleanClause.Occur.MUST_NOT);
                    break;
                }
                case TERM_CONTAINS: {
                    termQueries.add((Query)new WildcardQuery(new Term(fieldName, "*" + textPart + "*")), BooleanClause.Occur.MUST);
                    break;
                }
                case TERM_CONTAINS_NOT: {
                    containsOnlyNegationQueries = true;
                    termQueries.add((Query)new WildcardQuery(new Term(fieldName, "*" + textPart + "*")), BooleanClause.Occur.MUST_NOT);
                }
            }
        }
        if (containsOnlyNegationQueries) {
            termQueries.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        }
        return termQueries.build();
    }

    public static FieldType createIndexFieldType() {
        FieldType fieldType = new FieldType();
        fieldType.setIndexOptions(IndexOptions.DOCS);
        fieldType.setOmitNorms(true);
        fieldType.setStored(false);
        fieldType.setTokenized(true);
        fieldType.freeze();
        return fieldType;
    }
}

