/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.teamapps.universaldb.index.translation.TranslatableText;

public class DataStreamUtil {
    public static void writeStringWithLengthHeader(DataOutputStream dataOutputStream, String value) throws IOException {
        if (value == null || value.isEmpty()) {
            dataOutputStream.writeInt(0);
        } else {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
    }

    public static String readStringWithLengthHeader(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        if (length == 0) {
            return null;
        }
        byte[] stringBytes = new byte[length];
        dataInputStream.read(stringBytes);
        return new String(stringBytes, StandardCharsets.UTF_8);
    }

    public static void writeTranslatableText(DataOutputStream dataOutputStream, TranslatableText value) throws IOException {
        if (value == null) {
            dataOutputStream.writeInt(0);
        } else {
            byte[] bytes = value.getEncodedValue().getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
    }

    public static TranslatableText readTranslatableText(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        if (length == 0) {
            return null;
        }
        byte[] stringBytes = new byte[length];
        dataInputStream.read(stringBytes);
        return new TranslatableText(new String(stringBytes, StandardCharsets.UTF_8));
    }

    public static void writeByteArrayWithLengthHeader(DataOutputStream dataOutputStream, byte[] bytes) throws IOException {
        dataOutputStream.writeInt(bytes.length);
        dataOutputStream.write(bytes);
    }

    public static byte[] readByteArrayWithLengthHeader(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        byte[] bytes = new byte[length];
        dataInputStream.read(bytes);
        return bytes;
    }
}

