/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.teamapps.universaldb.index.fileng.FileFullTextContentEntry;
import org.teamapps.universaldb.index.fileng.FileFullTextContentEntryIterator;

public class FileTextContentIndex {
    private File indexFile;
    private BufferedOutputStream outputStream;

    public FileTextContentIndex(File path, String name) {
        this.indexFile = new File(path, name + ".idt");
    }

    public void addEntry(int recordId, int version, int length, String contentText) throws IOException {
        this.addEntry(new FileFullTextContentEntry(recordId, version, length, contentText));
    }

    public void addEntry(FileFullTextContentEntry entry) throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new BufferedOutputStream(new FileOutputStream(this.indexFile), 32000);
        }
        this.outputStream.write(entry.getIndexValue());
        this.outputStream.flush();
    }

    public FileFullTextContentEntryIterator getEntryIterator() throws IOException {
        return new FileFullTextContentEntryIterator(this.indexFile);
    }

    public void close() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void drop() {
        this.indexFile.delete();
    }
}

